/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.decorator;

import java.util.Iterator;
import java.util.List;
import org.optaplanner.core.impl.heuristic.move.Move;
import org.optaplanner.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.move.AbstractMoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class FilteringMoveSelector
extends AbstractMoveSelector {
    protected final MoveSelector childMoveSelector;
    protected final List<SelectionFilter> filterList;
    protected final boolean bailOutEnabled;
    protected ScoreDirector scoreDirector = null;

    public FilteringMoveSelector(MoveSelector childMoveSelector, List<SelectionFilter> filterList) {
        this.childMoveSelector = childMoveSelector;
        this.filterList = filterList;
        this.bailOutEnabled = childMoveSelector.isNeverEnding();
        this.phaseLifecycleSupport.addEventListener(childMoveSelector);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
    }

    @Override
    public boolean isCountable() {
        return this.childMoveSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childMoveSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.childMoveSelector.getSize();
    }

    @Override
    public Iterator<Move> iterator() {
        return new JustInTimeFilteringMoveIterator(this.childMoveSelector.iterator(), this.determineBailOutSize());
    }

    protected long determineBailOutSize() {
        if (!this.bailOutEnabled) {
            return -1L;
        }
        return this.childMoveSelector.getSize() * 10L;
    }

    protected boolean accept(ScoreDirector scoreDirector, Move move) {
        for (SelectionFilter filter : this.filterList) {
            if (filter.accept(scoreDirector, move)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Filtering(" + this.childMoveSelector + ")";
    }

    private class JustInTimeFilteringMoveIterator
    extends UpcomingSelectionIterator<Move> {
        private final Iterator<Move> childMoveIterator;
        private final long bailOutSize;

        public JustInTimeFilteringMoveIterator(Iterator<Move> childMoveIterator, long bailOutSize) {
            this.childMoveIterator = childMoveIterator;
            this.bailOutSize = bailOutSize;
        }

        @Override
        protected Move createUpcomingSelection() {
            Move next;
            long attemptsBeforeBailOut = this.bailOutSize;
            do {
                if (!this.childMoveIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
                if (!FilteringMoveSelector.this.bailOutEnabled) continue;
                if (attemptsBeforeBailOut <= 0L) {
                    FilteringMoveSelector.this.logger.warn("Bailing out of neverEnding selector ({}) to avoid infinite loop.", (Object)FilteringMoveSelector.this);
                    return (Move)this.noUpcomingSelection();
                }
                --attemptsBeforeBailOut;
            } while (!FilteringMoveSelector.this.accept(FilteringMoveSelector.this.scoreDirector, next = this.childMoveIterator.next()));
            return next;
        }
    }
}

