/*
 * Copyright (c) OSGi Alliance (2017, 2018). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.osgi.service.cdi.annotations;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Qualifier;

import org.osgi.service.cdi.reference.BindBeanServiceObjects;
import org.osgi.service.cdi.reference.BindService;
import org.osgi.service.cdi.reference.BindServiceReference;

/**
 * Used with {@link Reference @Reference}, {@link BindService},
 * {@link BindBeanServiceObjects} and {@link BindServiceReference} to indicate
 * that the service must be {@code service.scope=prototype}.
 *
 * @author $Id: df372371b9b2a0e480dfad5765b31f2747f5fcc8 $
 */
@Documented
@Qualifier
@Retention(RUNTIME)
@Target({FIELD, METHOD, PARAMETER, TYPE})
public @interface PrototypeRequired {

	/**
	 * Support inline instantiation of the {@link PrototypeRequired} annotation.
	 */
	public static final class Literal extends
			AnnotationLiteral<PrototypeRequired> implements PrototypeRequired {

		/**
		 * Default instance
		 */
		public static final PrototypeRequired	INSTANCE			= new Literal();

		private static final long			serialVersionUID	= 1L;

	}

}
