/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.storage.impl;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.osgl.$;
import org.osgl.Osgl;
import org.osgl.storage.ISObject;
import org.osgl.storage.IStorageService;
import org.osgl.storage.impl.FileObject;
import org.osgl.storage.impl.StorageServiceBase;
import org.osgl.util.C;
import org.osgl.util.E;
import org.osgl.util.IO;

public class FileSystemService
extends StorageServiceBase<FileObject>
implements IStorageService {
    public static final String CONF_HOME_DIR = "storage.fs.home.dir";
    @Deprecated
    public static final String CONF_HOME_URL = "storage.fs.home.url";
    @Deprecated
    public static final String CONF_FS_GET_NO_GET = "storage.fs.get.noGet";
    private File root_;
    private static final Osgl.Transformer<File, InputStream> SAFE_GET_INPUT_STREAM = new Osgl.Transformer<File, InputStream>(){

        public InputStream transform(File file) {
            return file.canRead() ? IO.is((File)file) : IO.is();
        }
    };
    private static final Osgl.Transformer<File, InputStream> GET_INPUT_STREAM = new Osgl.Transformer<File, InputStream>(){

        public InputStream transform(File file) {
            return IO.is((File)file);
        }
    };
    private static final Osgl.Visitor<File> DELETE_FILE = new Osgl.Visitor<File>(){

        public void visit(File file) throws Osgl.Break {
            IO.delete((File)file);
        }
    };

    public FileSystemService(Map<String, String> conf) {
        super(conf, FileObject.class);
    }

    @Override
    protected void configure(Map<String, String> conf) {
        if (!(conf = C.newMap(conf)).containsKey("storage.staticWebEndpoint") && conf.containsKey(CONF_HOME_URL)) {
            conf.put("storage.staticWebEndpoint", conf.get(CONF_HOME_URL));
        }
        if (!conf.containsKey("storage.get.noGet") && conf.containsKey(CONF_FS_GET_NO_GET)) {
            conf.put("storage.get.noGet", conf.get(CONF_FS_GET_NO_GET));
        }
        super.configure((Map<String, String>)conf, "fs");
        String s = (String)conf.get(CONF_HOME_DIR);
        this.root_ = new File(s);
        if (!this.root_.exists() && !this.root_.mkdirs()) {
            throw E.invalidConfiguration((String)"Cannot create root dir: %s", (Object[])new Object[]{this.root_.getAbsolutePath()});
        }
        if (!this.root_.isDirectory()) {
            throw E.invalidConfiguration((String)"Root dir specified is not a directory: %s", (Object[])new Object[]{this.root_.getAbsolutePath()});
        }
    }

    public File root() {
        return this.root_;
    }

    @Override
    protected void doRemove(String fullPath) {
        this.doOperate(fullPath, (Osgl.Function)DELETE_FILE, (Osgl.Function)DELETE_FILE);
    }

    @Override
    protected Map<String, String> doGetMeta(String fullPath) {
        InputStream is = this.doOperate(fullPath, null, (Osgl.Function)SAFE_GET_INPUT_STREAM);
        if (null == is) {
            return C.newMap((Object[])new Object[0]);
        }
        Properties p = new Properties();
        try {
            p.load(is);
        }
        catch (IOException e) {
            throw E.ioException((IOException)e);
        }
        finally {
            IO.close((Closeable)is);
        }
        return (Map)$.cast((Object)p);
    }

    protected File doGetFile(String fullPath) {
        return (File)this.doOperate(fullPath, (Osgl.Function)Osgl.F.identity(), null);
    }

    @Override
    protected InputStream doGetInputStream(String fullPath) {
        return this.doOperate(fullPath, (Osgl.Function)GET_INPUT_STREAM, null);
    }

    protected File getFile(String fullPath) {
        fullPath = fullPath.replace('\\', '/');
        String[] path = fullPath.split("/");
        int len = path.length;
        assert (len > 0);
        File folder = this.root_;
        for (int i = 0; i < len - 1; ++i) {
            if (!(folder = IO.child((File)folder, (String)path[i])).exists() || folder.isDirectory()) continue;
            throw E.ioException((String)"cannot store the object into storage: %s is not a directory", (Object[])new Object[]{folder});
        }
        return new File(folder, path[len - 1]);
    }

    private <T> T doOperate(String fullPath, Osgl.Function<File, T> blobOperator, Osgl.Function<File, T> attrOperator) {
        return this.doOperate(fullPath, blobOperator, attrOperator, false);
    }

    private <T> T doOperate(String fullPath, Osgl.Function<File, T> blobOperator, Osgl.Function<File, T> attrOperator, boolean mkdir) {
        File dir;
        File file = this.getFile(fullPath);
        Object retVal = null;
        if (mkdir && !(dir = file.getParentFile()).exists() && !dir.mkdirs()) {
            throw E.ioException((String)("Cannot create dir: " + dir.getAbsolutePath()), (Object[])new Object[0]);
        }
        if (null != blobOperator) {
            retVal = blobOperator.apply((Object)file);
        }
        if (null != attrOperator) {
            File fAttr = new File(file.getParent(), file.getName() + ".attr");
            if (null != retVal) {
                retVal = attrOperator.apply((Object)fAttr);
            } else {
                attrOperator.apply((Object)fAttr);
            }
        }
        return (T)retVal;
    }

    @Override
    protected ISObject newSObject(String key) {
        return new FileObject(key, this);
    }

    @Override
    protected void doPut(String fullPath, ISObject stuff, Map<String, String> attrs) {
        this.doOperate(fullPath, (Osgl.Function)FileSystemService.writeBlob(stuff), (Osgl.Function)FileSystemService.writeAttributes(attrs), true);
    }

    @Override
    protected StorageServiceBase newService(Map<String, String> conf) {
        return new FileSystemService(conf);
    }

    private static Osgl.Visitor<File> writeBlob(final ISObject sobj) {
        return new Osgl.Visitor<File>(){

            public void visit(File file) throws Osgl.Break {
                BufferedOutputStream os = new BufferedOutputStream(IO.os((File)file));
                IO.write((InputStream)IO.buffered((InputStream)sobj.asInputStream()), (OutputStream)os);
            }
        };
    }

    private static Osgl.Visitor<File> writeAttributes(final Map<String, String> attrs) {
        return new Osgl.Visitor<File>(){

            public void visit(File file) throws Osgl.Break {
                if (null != attrs && !attrs.isEmpty()) {
                    BufferedOutputStream os = IO.buffered((OutputStream)IO.os((File)file));
                    Properties p = new Properties();
                    p.putAll((Map<?, ?>)attrs);
                    try {
                        p.store(os, "");
                    }
                    catch (IOException e) {
                        throw E.ioException((IOException)e);
                    }
                    IO.close((Closeable)os);
                }
            }
        };
    }
}

