/*
 * Decompiled with CFR 0.152.
 */
package org.osgl.storage.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.activation.MimetypesFileTypeMap;
import org.osgl.util.C;
import org.osgl.util.IO;
import org.osgl.util.S;

public class MimeTypes {
    private static Map<String, String> commonMimeTypes = C.map((Object[])new Object[]{"pdf", "application/pdf", "png", "image/png", "bmp", "image/bmp"});
    private static MimetypesFileTypeMap activationMimeTypes = new MimetypesFileTypeMap();
    private static Properties mimeTypes;

    public static String mimeType(File file) {
        return MimeTypes.mimeType(file.getName());
    }

    public static String mimeType(String fileName) {
        String suffix = S.afterLast((String)fileName, (String)".");
        String mimeType = commonMimeTypes.get(suffix);
        if (null != mimeType) {
            return mimeType;
        }
        mimeType = mimeTypes.getProperty(S.afterLast((String)fileName, (String)"."));
        return null != mimeType ? mimeType : activationMimeTypes.getContentType(fileName);
    }

    static {
        String OSGL_HTTP_MIME_TYPES = "/org/osgl/http/mime-types.properties";
        try {
            mimeTypes = IO.loadProperties((InputStream)IO.is((URL)MimeTypes.class.getResource("/org/osgl/http/mime-types.properties")));
        }
        catch (Exception e) {
            mimeTypes = new Properties();
        }
    }
}

