/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.apiman.dt.ui.server.servlets;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jackson.map.ObjectMapper;
import org.overlord.apiman.dt.ui.client.shared.beans.BearerTokenCredentialsBean;
import org.overlord.apiman.dt.ui.server.UIConfig;
import org.overlord.apiman.dt.ui.server.auth.ITokenGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenRefreshServlet
extends HttpServlet {
    private static final long serialVersionUID = 7721708152826837757L;
    private static Logger logger = LoggerFactory.getLogger(TokenRefreshServlet.class);
    private transient ITokenGenerator tokenGenerator;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.debug("Refreshing authentication token.");
        ITokenGenerator tokenGenerator = this.getTokenGenerator();
        String token = tokenGenerator.generateToken(req);
        int refresh = tokenGenerator.getRefreshPeriod();
        BearerTokenCredentialsBean btcb = new BearerTokenCredentialsBean();
        btcb.setToken(new String(Base64.encodeBase64((byte[])token.getBytes("UTF-8"))));
        btcb.setRefreshPeriod(refresh);
        ObjectMapper mapper = new ObjectMapper();
        resp.setContentType("application/json");
        resp.setDateHeader("Date", System.currentTimeMillis());
        resp.setDateHeader("Expires", System.currentTimeMillis() - 86400000L);
        resp.setHeader("Pragma", "no-cache");
        resp.setHeader("Cache-control", "no-cache, no-store, must-revalidate");
        mapper.writer().writeValue((OutputStream)resp.getOutputStream(), (Object)btcb);
    }

    private ITokenGenerator getTokenGenerator() {
        if (this.tokenGenerator == null) {
            String tokenGeneratorClassName = UIConfig.config.getString("apiman-dt-ui.dt-api.authentication.token.generator");
            if (tokenGeneratorClassName == null) {
                throw new RuntimeException("No token generator class specified.");
            }
            try {
                Class<?> c = Class.forName(tokenGeneratorClassName);
                this.tokenGenerator = (ITokenGenerator)c.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Error creating token generator.");
            }
        }
        return this.tokenGenerator;
    }
}

