/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.jbpm.util;

import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.jbpm.kie.services.impl.KModuleDeploymentUnit;
import org.kie.api.KieServices;
import org.kie.api.builder.KieModule;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.ReleaseId;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.internal.deployment.DeploymentUnit;
import org.overlord.dtgov.jbpm.util.ProcessEngineService;
import org.overlord.dtgov.server.i18n.Messages;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;
import org.overlord.sramp.governance.SrampMavenUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieSrampUtil {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static String SRAMP_KIE_JAR_QUERY = "/s-ramp/ext/KieJarArchive[@maven.groupId=? and @maven.artifactId = ? and @maven.version = ? and xp2:not(@maven.classifier)]";
    private static final String SRAMP_KIE_MODEL = "/s-ramp/ext/KieJarArchive";

    public boolean isSRAMPPackageDeployed(String groupId, String artifactId, String version) {
        try {
            SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
            QueryResultSet results = client.buildQuery(SRAMP_KIE_JAR_QUERY).parameter(groupId).parameter(artifactId).parameter(version).count(1).query();
            if (results.size() > 0L) {
                return Boolean.TRUE;
            }
        }
        catch (SrampClientException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SrampAtomException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return Boolean.FALSE;
    }

    public KieContainer getKieContainer(ReleaseId releaseId) throws SrampClientException, SrampAtomException {
        String workflowArtifactId;
        KieServices ks = KieServices.Factory.get();
        KieRepository repo = ks.getRepository();
        SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
        Governance governance = new Governance();
        String workflowGroupId = governance.getGovernanceWorkflowGroup();
        String workflowVersion = SrampMavenUtil.getVersion((String)SRAMP_KIE_MODEL, (String)workflowGroupId, (String)(workflowArtifactId = governance.getGovernanceWorkflowName()), (String)governance.getGovernanceWorkflowVersion());
        if (StringUtils.isBlank((String)workflowVersion)) {
            throw new RuntimeException(Messages.i18n.format("maven.version.not.found", new Object[]{workflowGroupId, workflowArtifactId, workflowVersion}));
        }
        QueryResultSet results = null;
        ArtifactSummary artifactSummary = null;
        results = client.buildQuery(SRAMP_KIE_JAR_QUERY).parameter(workflowGroupId).parameter(workflowArtifactId).parameter(workflowVersion).count(1).query();
        if (results.size() > 0L) {
            artifactSummary = results.get(0);
            InputStream is = client.getArtifactContent(artifactSummary);
            KieModule kModule = repo.addKieModule(ks.getResources().newInputStreamResource(is), new Resource[0]);
            this.logger.info(Messages.i18n.format("KieSrampUtil.CreatingKieContainer", new Object[]{artifactSummary.getName()}));
            KieContainer kContainer = ks.newKieContainer(kModule.getReleaseId());
            this.logger.info(Messages.i18n.format("KieSrampUtil.FindKieBase", new Object[]{governance.getGovernanceWorkflowPackage()}));
            return kContainer;
        }
        return null;
    }

    public RuntimeManager getRuntimeManager(ProcessEngineService processEngineService, String deploymentId) {
        String[] deploymentInfo = deploymentId.split(":");
        if (deploymentInfo.length != 5) {
            throw new IllegalStateException(Messages.i18n.format("KieSrampUtil.DeploymentIdFormat", new Object[0]));
        }
        KModuleDeploymentUnit unit = new KModuleDeploymentUnit(deploymentInfo[0], deploymentInfo[1], deploymentInfo[2], deploymentInfo[3], deploymentInfo[4]);
        return this.getRuntimeManager(processEngineService, unit);
    }

    public RuntimeManager getRuntimeManager(ProcessEngineService processEngineService, KModuleDeploymentUnit unit) {
        RuntimeManager runtimeManager = processEngineService.getRuntimeManager(unit.getIdentifier());
        if (runtimeManager == null) {
            if (this.isSRAMPPackageDeployed(unit.getGroupId(), unit.getArtifactId(), unit.getVersion())) {
                unit.setStrategy(DeploymentUnit.RuntimeStrategy.PER_PROCESS_INSTANCE);
                processEngineService.deployUnit(unit);
                runtimeManager = processEngineService.getRuntimeManager(unit.getIdentifier());
                this.logger.info(Messages.i18n.format("KieSrampUtil.FoundAndDeployed", new Object[]{unit.getIdentifier()}));
            } else {
                this.logger.error(Messages.i18n.format("KieSrampUtil.NotFound", new Object[]{unit.getIdentifier()}));
                throw new IllegalStateException(Messages.i18n.format("KieSrampUtil.NotFound", new Object[]{unit.getIdentifier()}));
            }
        }
        return runtimeManager;
    }
}

