/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;

public class SrampMavenUtil {
    private static final String MAVEN_VERSION_LATEST = "LATEST";
    private static final String MAVEN_VERSION_RELEASE = "RELEASE";
    private static final String MAVEN_QUERY_PARAMETERS = "@maven.groupId=? and @maven.artifactId = ? and xp2:not(@maven.classifier)";

    public static String getVersion(String queryModel, String mavenGroupId, String mavenArtifactId, String mavenVersion) throws SrampClientException, SrampAtomException {
        if (mavenVersion.equals(MAVEN_VERSION_LATEST) || mavenVersion.equals(MAVEN_VERSION_RELEASE)) {
            QueryResultSet results = null;
            StringBuilder queryBuilder = new StringBuilder();
            queryBuilder.append(queryModel).append("[").append(MAVEN_QUERY_PARAMETERS).append("]");
            SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
            if (mavenVersion.equals(MAVEN_VERSION_LATEST)) {
                results = client.buildQuery(queryBuilder.toString()).parameter(mavenGroupId).parameter(mavenArtifactId).propertyName("maven.version").orderBy("createdTimestamp").descending().count(1).query();
                if (results.size() > 0L) {
                    return results.get(0).getCustomPropertyValue("maven.version");
                }
                return null;
            }
            if (mavenVersion.equals(MAVEN_VERSION_RELEASE)) {
                int page = 0;
                int page_size = 50;
                boolean moreItems = true;
                while (moreItems) {
                    results = client.buildQuery(queryBuilder.toString()).parameter(mavenGroupId).parameter(mavenArtifactId).propertyName("maven.version").orderBy("createdTimestamp").descending().count(page_size).startIndex(page * page_size).query();
                    for (ArtifactSummary artSumm : results) {
                        String version = artSumm.getCustomPropertyValue("maven.version");
                        if (version.endsWith("-SNAPSHOT")) continue;
                        return version;
                    }
                    if (results.getTotalResults() >= (long)(++page * page_size)) continue;
                    moreItems = false;
                }
                return null;
            }
        } else {
            return mavenVersion;
        }
        return null;
    }
}

