/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.services.notification;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.overlord.dtgov.server.i18n.Messages;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.SrampClientQuery;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;
import org.overlord.sramp.governance.services.notification.NotificationTemplateTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class NotificationResourceUtil {
    private static final String GET_TEMPLATE_QUERY = "/s-ramp/ext/DtgovEmailTemplate[@template = ? and @template-type = ?]";
    private static Logger logger = LoggerFactory.getLogger(NotificationResourceUtil.class);
    public static final String CLASSPATH_FOLDER = "/governance-email-templates/";

    public static String getNotificationSubject(String template) throws IOException {
        return NotificationResourceUtil.getTemplate((String)template, (String)NotificationTemplateTypeEnum.SUBJECT.value(), (String)"/governance-email-templates/");
    }

    public static String getNotificationBody(String template) throws IOException {
        return NotificationResourceUtil.getTemplate((String)template, (String)NotificationTemplateTypeEnum.BODY.value(), (String)"/governance-email-templates/");
    }

    private static String getTemplate(String template, String templateType, String classpathFolder) throws IOException {
        String toReturn = "";
        toReturn = NotificationResourceUtil.getTemplateFromQuery((String)template, (String)templateType);
        if (StringUtils.isBlank((String)toReturn)) {
            String resource = classpathFolder + template + "." + templateType + ".tmpl";
            URL resourceUrl = Governance.class.getClassLoader().getResource(resource);
            if (resourceUrl != null) {
                toReturn = IOUtils.toString((URL)resourceUrl);
            }
        }
        return toReturn;
    }

    private static String getTemplateFromQuery(String template, String templateType) {
        SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
        SrampClientQuery query = client.buildQuery("/s-ramp/ext/DtgovEmailTemplate[@template = ? and @template-type = ?]").parameter(template).parameter(templateType);
        QueryResultSet resultSet = null;
        try {
            resultSet = query.query();
        }
        catch (SrampClientException e) {
            logger.warn(Messages.i18n.format("NotificationResourceUtil.query.client.error", new Object[]{query.toString()}), (Throwable)e);
        }
        catch (SrampAtomException e) {
            logger.warn(Messages.i18n.format("NotificationResourceUtil.query.atom.error", new Object[]{query.toString()}), (Throwable)e);
        }
        if (resultSet != null && resultSet.size() == 1L) {
            ArtifactSummary artifactSummary = resultSet.get(0);
            InputStream is = null;
            try {
                is = client.getArtifactContent(artifactSummary);
            }
            catch (SrampClientException e) {
                logger.warn(Messages.i18n.format("NotificationResourceUtil.query.client.getArtifactContent.error", new Object[]{artifactSummary}), (Throwable)e);
            }
            catch (SrampAtomException e) {
                logger.warn(Messages.i18n.format("NotificationResourceUtil.query.atom.getArtifactContent.error", new Object[]{artifactSummary}), (Throwable)e);
            }
            if (is != null) {
                try {
                    return IOUtils.toString((InputStream)is);
                }
                catch (IOException e) {
                    logger.warn(Messages.i18n.format("NotificationResourceUtil.query.ioutils.to.string", new Object[0]), (Throwable)e);
                }
            }
        } else {
            logger.warn(Messages.i18n.format("NotificationResourceUtil.query.no.result", new Object[]{template, templateType}));
        }
        return null;
    }
}

