/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.dtgov.jbpm.util;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.util.GenericType;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.overlord.dtgov.server.i18n.Messages;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.ValueEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientWorkItemHandler
implements WorkItemHandler {
    Logger log = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
        Governance governance = new Governance();
        ClientResponse response = null;
        HashMap<String, String> results = new HashMap<String, String>();
        try {
            String urlStr = (String)workItem.getParameter("Url");
            String method = (String)workItem.getParameter("Method");
            if (urlStr == null || method == null) {
                throw new Exception(Messages.i18n.format("HttpClientWorkItemHandler.MissingParams", new Object[0]));
            }
            urlStr = urlStr.toLowerCase();
            urlStr = urlStr.replaceAll("\\{governance.url\\}", governance.getGovernanceUrl());
            Map params = workItem.getParameters();
            for (String key : params.keySet()) {
                if (!urlStr.contains("{")) break;
                String variable = "{" + key.toLowerCase() + "}";
                if (!urlStr.contains(variable)) continue;
                String escapedVariable = "\\{" + key.toLowerCase() + "\\}";
                String urlEncodedParam = URLEncoder.encode((String)params.get(key), "UTF-8").replaceAll("%2F", "*2F");
                urlStr = urlStr.replaceAll(escapedVariable, urlEncodedParam);
            }
            if (urlStr.contains("{")) {
                throw new Exception(Messages.i18n.format("HttpClientWorkItemHandler.IncorrectParams", new Object[]{urlStr}));
            }
            this.log.info(Messages.i18n.format("HttpClientWorkItemHandler.CallingTo", new Object[]{method, urlStr}));
            DefaultHttpClient httpClient = new DefaultHttpClient();
            String username = governance.getOverlordUser();
            String password = governance.getOverlordPassword();
            httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
            ApacheHttpClient4Executor executor = new ApacheHttpClient4Executor((HttpClient)httpClient);
            ClientRequest request = new ClientRequest(urlStr, (ClientExecutor)executor);
            request.setHttpMethod(method);
            response = request.execute();
            int responseCode = response.getResponseStatus().getStatusCode();
            if (responseCode >= 200 && responseCode < 300) {
                Map map = (Map)response.getEntity((GenericType)new /* Unavailable Anonymous Inner Class!! */);
                for (String key : map.keySet()) {
                    if (((ValueEntity)map.get(key)).getValue() == null) continue;
                    results.put(key, ((ValueEntity)map.get(key)).getValue());
                }
                this.log.info("reply=" + results);
            } else {
                results.put("Status", "ERROR " + responseCode);
                results.put("StatusMsg", Messages.i18n.format("HttpClientWorkItemHandler.UnreachableEndpoint", new Object[]{urlStr}));
                this.log.error(Messages.i18n.format("HttpClientWorkItemHandler.UnreachableEndpoint", new Object[]{urlStr}));
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (response != null) {
                response.releaseConnection();
            }
        }
        manager.completeWorkItem(workItem.getId(), results);
    }

    public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
    }
}

