/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.dtgov.common.exception.ConfigException;
import org.overlord.dtgov.server.i18n.Messages;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.client.SrampClientQuery;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.governance.Query;
import org.overlord.sramp.governance.SrampAtomApiClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryAccessor {
    private static Logger logger = LoggerFactory.getLogger(QueryAccessor.class);
    private static final String QUERY = "/s-ramp/ext/DtgovWorkflowQuery[@query]";
    private static final String PROPERTY_PREFIX = "prop.";
    private static final String PROPERTY_QUERY = "query";
    private static final String PROPERTY_WORKLOW = "workflow";

    public Set<Query> getQueries() throws ConfigException {
        HashSet<Query> queries = new HashSet<Query>();
        SrampAtomApiClient client = SrampAtomApiClientFactory.createAtomApiClient();
        SrampClientQuery query = client.buildQuery(QUERY);
        SrampClientQuery scq = query.startIndex(0);
        try {
            QueryResultSet resultSet = scq.query();
            for (ArtifactSummary artifactSummary : resultSet) {
                BaseArtifactType artifact = client.getArtifactMetaData(artifactSummary.getUuid());
                Query q = new Query(SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)PROPERTY_QUERY), SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)PROPERTY_WORKLOW));
                Map props = SrampModelUtils.getCustomPropertiesByPrefix((BaseArtifactType)artifact, (String)PROPERTY_PREFIX);
                HashMap props_without_prefix = new HashMap();
                for (String key : props.keySet()) {
                    props_without_prefix.put(key.substring(PROPERTY_PREFIX.length()), props.get(key));
                }
                q.setParameters(props_without_prefix);
                queries.add(q);
            }
        }
        catch (SrampClientException e) {
            logger.error(Messages.i18n.format("QueryExecutor.ExceptionFor", new Object[]{e.getMessage()}), (Throwable)e);
        }
        catch (SrampAtomException e) {
            logger.error(Messages.i18n.format("QueryExecutor.ExceptionFor", new Object[]{e.getMessage()}), (Throwable)e);
        }
        return queries;
    }
}

