/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.suppression.SuppressionParseException;
import org.owasp.dependencycheck.suppression.SuppressionParser;
import org.owasp.dependencycheck.suppression.SuppressionRule;
import org.owasp.dependencycheck.utils.Settings;

public abstract class AbstractSuppressionAnalyzer
extends AbstractAnalyzer {
    private List<SuppressionRule> rules;

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return true;
    }

    @Override
    public void initialize() throws Exception {
        super.initialize();
        this.loadSuppressionData();
    }

    public List<SuppressionRule> getRules() {
        return this.rules;
    }

    public void setRules(List<SuppressionRule> rules) {
        this.rules = rules;
    }

    private void loadSuppressionData() throws SuppressionParseException {
        File file = Settings.getFile("suppression.file");
        if (file != null) {
            SuppressionParser parser = new SuppressionParser();
            try {
                this.rules = parser.parseSuppressionRules(file);
            }
            catch (SuppressionParseException ex) {
                String msg = String.format("Unable to parse suppression xml file '%s'", file.getPath());
                Logger.getLogger(AbstractSuppressionAnalyzer.class.getName()).log(Level.WARNING, msg);
                Logger.getLogger(AbstractSuppressionAnalyzer.class.getName()).log(Level.WARNING, ex.getMessage());
                Logger.getLogger(AbstractSuppressionAnalyzer.class.getName()).log(Level.FINE, null, ex);
                throw ex;
            }
        }
    }
}

