/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisException;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Analyzer;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.utils.DependencyVersion;
import org.owasp.dependencycheck.utils.DependencyVersionUtil;
import org.owasp.dependencycheck.utils.LogUtils;

public class DependencyBundlingAnalyzer
extends AbstractAnalyzer
implements Analyzer {
    private static final Pattern STARTING_TEXT_PATTERN = Pattern.compile("^[a-zA-Z]*");
    private boolean analyzed = false;
    private static final Set<String> EXTENSIONS = null;
    private static final String ANALYZER_NAME = "Dependency Bundling Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.PRE_FINDING_ANALYSIS;

    @Override
    public Set<String> getSupportedExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public boolean supportsExtension(String extension) {
        return true;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    public void analyze(Dependency ignore, Engine engine) throws AnalysisException {
        if (!this.analyzed) {
            this.analyzed = true;
            HashSet<Dependency> dependenciesToRemove = new HashSet<Dependency>();
            ListIterator<Dependency> mainIterator = engine.getDependencies().listIterator();
            while (mainIterator.hasNext()) {
                Dependency dependency = mainIterator.next();
                if (!mainIterator.hasNext()) continue;
                ListIterator<Dependency> subIterator = engine.getDependencies().listIterator(mainIterator.nextIndex());
                while (subIterator.hasNext()) {
                    Iterator<Dependency> i;
                    Dependency nextDependency = subIterator.next();
                    if (!this.identifiersMatch(dependency, nextDependency) || !this.hasSameBasePath(dependency, nextDependency) || !this.fileNameMatch(dependency, nextDependency)) continue;
                    if (this.isCore(dependency, nextDependency)) {
                        dependency.addRelatedDependency(nextDependency);
                        i = nextDependency.getRelatedDependencies().iterator();
                        while (i.hasNext()) {
                            dependency.addRelatedDependency(i.next());
                            i.remove();
                        }
                        dependenciesToRemove.add(nextDependency);
                        continue;
                    }
                    nextDependency.addRelatedDependency(dependency);
                    i = dependency.getRelatedDependencies().iterator();
                    while (i.hasNext()) {
                        nextDependency.addRelatedDependency(i.next());
                        i.remove();
                    }
                    dependenciesToRemove.add(dependency);
                }
            }
            for (Dependency d : dependenciesToRemove) {
                engine.getDependencies().remove(d);
            }
        }
    }

    private String getBaseRepoPath(String path) {
        int pos = path.indexOf("repository" + File.separator) + 11;
        if (pos < 0) {
            return path;
        }
        int tmp = path.indexOf(File.separator, pos);
        if (tmp <= 0) {
            return path;
        }
        if (tmp > 0) {
            pos = tmp + 1;
        }
        if ((tmp = path.indexOf(File.separator, pos)) > 0) {
            pos = tmp + 1;
        }
        return path.substring(0, pos);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean fileNameMatch(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency1.getFileName() == null || dependency2 == null || dependency2.getFileName() == null) {
            return false;
        }
        String fileName1 = dependency1.getFileName();
        String fileName2 = dependency2.getFileName();
        File one = new File(fileName1);
        File two = new File(fileName2);
        String oneParent = one.getParent();
        String twoParent = two.getParent();
        if (oneParent != null) {
            if (twoParent == null || !oneParent.equals(twoParent)) return false;
            fileName1 = one.getName();
            fileName2 = two.getName();
        } else if (twoParent != null) {
            return false;
        }
        DependencyVersion version1 = DependencyVersionUtil.parseVersion(fileName1);
        DependencyVersion version2 = DependencyVersionUtil.parseVersion(fileName2);
        if (version1 != null && version2 != null && !version1.equals(version2)) {
            return false;
        }
        Matcher match1 = STARTING_TEXT_PATTERN.matcher(fileName1);
        Matcher match2 = STARTING_TEXT_PATTERN.matcher(fileName2);
        if (!match1.find() || !match2.find()) return false;
        return match1.group().equals(match2.group());
    }

    private boolean identifiersMatch(Dependency dependency1, Dependency dependency2) {
        boolean matches;
        if (dependency1 == null || dependency1.getIdentifiers() == null || dependency2 == null || dependency2.getIdentifiers() == null) {
            return false;
        }
        boolean bl = matches = dependency1.getIdentifiers().size() > 0 && ((Object)dependency2.getIdentifiers()).equals(dependency1.getIdentifiers());
        if (LogUtils.isVerboseLoggingEnabled()) {
            String msg = String.format("IdentifiersMatch=%s (%s, %s)", matches, dependency1.getFileName(), dependency2.getFileName());
            Logger.getLogger(DependencyBundlingAnalyzer.class.getName()).log(Level.FINE, msg);
        }
        return matches;
    }

    private boolean hasSameBasePath(Dependency dependency1, Dependency dependency2) {
        if (dependency1 == null || dependency2 == null) {
            return false;
        }
        File lFile = new File(dependency1.getFilePath());
        String left = lFile.getParent();
        File rFile = new File(dependency2.getFilePath());
        String right = rFile.getParent();
        if (left == null) {
            return right == null;
        }
        if (left.equalsIgnoreCase(right)) {
            return true;
        }
        if (left.matches(".*[/\\\\]repository[/\\\\].*") && right.matches(".*[/\\\\]repository[/\\\\].*")) {
            left = this.getBaseRepoPath(left);
            right = this.getBaseRepoPath(right);
        }
        return left.equalsIgnoreCase(right);
    }

    private boolean isCore(Dependency left, Dependency right) {
        String leftName = left.getFileName().toLowerCase();
        String rightName = right.getFileName().toLowerCase();
        boolean returnVal = rightName.contains("core") && !leftName.contains("core") ? false : (!rightName.contains("core") && leftName.contains("core") ? true : leftName.length() <= rightName.length());
        if (LogUtils.isVerboseLoggingEnabled()) {
            String msg = String.format("IsCore=%s (%s, %s)", returnVal, left.getFileName(), right.getFileName());
            Logger.getLogger(DependencyBundlingAnalyzer.class.getName()).log(Level.FINE, msg);
        }
        return returnVal;
    }
}

