/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.owasp.dependencycheck.data.UpdateException;
import org.owasp.dependencycheck.data.update.NvdCveInfo;
import org.owasp.dependencycheck.utils.Settings;

public class DataStoreMetaInfo {
    public static final String BATCH = "batch";
    public static final String MODIFIED = "modified";
    private static final String UPDATE_PROPERTIES_FILE = "data.properties";
    public static final String LAST_UPDATED = "lastupdated.modified";
    public static final String LAST_UPDATED_BASE = "lastupdated.";
    private Properties properties = new Properties();
    private boolean batchUpdateMode = !Settings.getString("batch.update.url", "").isEmpty();

    protected boolean isBatchUpdateMode() {
        return this.batchUpdateMode;
    }

    protected void setBatchUpdateMode(boolean batchUpdateMode) {
        this.batchUpdateMode = batchUpdateMode;
    }

    public DataStoreMetaInfo() {
        this.loadProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadProperties() {
        File file = DataStoreMetaInfo.getPropertiesFile();
        if (!file.exists()) return;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException ignore) {
            Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINEST, null, ignore);
        }
        this.properties.load(is);
        if (is == null) return;
        try {
            ((InputStream)is).close();
            return;
        }
        catch (IOException ex) {
            String msg = String.format("Unable to close properties file '%s'", file.getPath());
            Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.WARNING, msg);
            Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINE, null, ex);
        }
        return;
        catch (IOException ex) {
            String msg;
            try {
                msg = String.format("Unable to load properties file '%s'", file.getPath());
                Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.WARNING, msg);
                Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINE, null, ex);
                if (is == null) return;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    ((InputStream)is).close();
                    throw throwable;
                }
                catch (IOException ex2) {
                    String msg2 = String.format("Unable to close properties file '%s'", file.getPath());
                    Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.WARNING, msg2);
                    Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINE, null, ex2);
                }
                throw throwable;
            }
            try {
                ((InputStream)is).close();
                return;
            }
            catch (IOException ex3) {
                msg = String.format("Unable to close properties file '%s'", file.getPath());
                Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.WARNING, msg);
                Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINE, null, ex3);
            }
            return;
        }
    }

    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(NvdCveInfo updatedValue) throws UpdateException {
        if (updatedValue == null) {
            return;
        }
        File cveProp = DataStoreMetaInfo.getPropertiesFile();
        Properties prop = new Properties();
        if (cveProp.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(cveProp);
                prop.load(in);
            }
            catch (Exception ignoreMe) {
                Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINEST, null, ignoreMe);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception ignoreMeToo) {
                        Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINEST, null, ignoreMeToo);
                    }
                }
            }
        }
        prop.put("version", "2.7");
        prop.put(LAST_UPDATED_BASE + updatedValue.getId(), String.valueOf(updatedValue.getTimestamp()));
        FileOutputStream os = null;
        OutputStreamWriter out = null;
        try {
            os = new FileOutputStream(cveProp);
            out = new OutputStreamWriter((OutputStream)os, "UTF-8");
            prop.store(out, "Meta data about data and data sources used by dependency-check");
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINE, null, ex);
            throw new UpdateException("Unable to find last updated properties file.", ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINE, null, ex);
            throw new UpdateException("Unable to update last updated properties file.", ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINEST, null, ex);
                }
            }
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException ex) {
                    Logger.getLogger(DataStoreMetaInfo.class.getName()).log(Level.FINEST, null, ex);
                }
            }
        }
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public static File getPropertiesFile() {
        File dataDirectory = Settings.getDataFile("data.directory");
        File file = new File(dataDirectory, UPDATE_PROPERTIES_FILE);
        return file;
    }
}

