/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.input.BOMInputStream;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.NuspecAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.nuget.DirectoryBuildPropsParser;
import org.owasp.dependencycheck.data.nuget.DirectoryPackagesPropsParser;
import org.owasp.dependencycheck.data.nuget.MSBuildProjectParseException;
import org.owasp.dependencycheck.data.nuget.NugetPackageReference;
import org.owasp.dependencycheck.data.nuget.XPathMSBuildProjectParser;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MSBuildProjectAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NuspecAnalyzer.class);
    private static final String ANALYZER_NAME = "MSBuild Project Analyzer";
    private static final AnalysisPhase ANALYSIS_PHASE = AnalysisPhase.INFORMATION_COLLECTION;
    private static final String[] SUPPORTED_EXTENSIONS = new String[]{"csproj", "vbproj"};
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions(SUPPORTED_EXTENSIONS).build();
    private static final String IMPORT_GET_DIRECTORY = "$([MSBuild]::GetDirectoryNameOfFileAbove($(MSBuildThisFileDirectory)..,Directory.Build.props))\\Directory.Build.props";
    private static final String IMPORT_GET_PATH_OF_FILE = "$([MSBuild]::GetPathOfFileAbove('Directory.Build.props','$(MSBuildThisFileDirectory)../'))";
    private static final String DIRECTORY_BUILDPROPS = "Directory.Build.props";
    private static final String DIRECTORY_PACKAGESPROPS = "Directory.Packages.props";

    @Override
    public String getName() {
        return ANALYZER_NAME;
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return ANALYSIS_PHASE;
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.msbuildproject.enabled";
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        File parent = dependency.getActualFile().getParentFile();
        try {
            List<NugetPackageReference> packages;
            Properties props = this.loadDirectoryBuildProps(parent);
            Map<String, String> centrallyManaged = this.loadCentrallyManaged(parent, props);
            LOGGER.debug("Checking MSBuild project file {}", (Object)dependency);
            XPathMSBuildProjectParser parser = new XPathMSBuildProjectParser();
            try (FileInputStream fis = new FileInputStream(dependency.getActualFilePath());
                 BOMInputStream bis = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream((InputStream)fis)).get();){
                bis.getBOM();
                packages = parser.parse((InputStream)bis, props, centrallyManaged);
            }
            catch (FileNotFoundException | MSBuildProjectParseException ex) {
                throw new AnalysisException(ex);
            }
            if (packages == null || packages.isEmpty()) {
                return;
            }
            for (NugetPackageReference npr : packages) {
                Dependency child = new Dependency(dependency.getActualFile(), true);
                String id = npr.getId();
                String version = npr.getVersion();
                child.setEcosystem("dotnet");
                child.setName(id);
                child.setVersion(version);
                try {
                    PackageURL purl = PackageURLBuilder.aPackageURL().withType("nuget").withName(id).withVersion(version).build();
                    child.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
                }
                catch (MalformedPackageURLException ex) {
                    LOGGER.debug("Unable to build package url for msbuild", (Throwable)ex);
                    GenericIdentifier gid = new GenericIdentifier("msbuild:" + id + "@" + version, Confidence.HIGHEST);
                    child.addSoftwareIdentifier(gid);
                }
                child.setPackagePath(String.format("%s:%s", id, version));
                child.setSha1sum(Checksum.getSHA1Checksum((String)String.format("%s:%s", id, version)));
                child.setSha256sum(Checksum.getSHA256Checksum((String)String.format("%s:%s", id, version)));
                child.setMd5sum(Checksum.getMD5Checksum((String)String.format("%s:%s", id, version)));
                child.addEvidence(EvidenceType.PRODUCT, "msbuild", "id", id, Confidence.HIGHEST);
                child.addEvidence(EvidenceType.VERSION, "msbuild", "version", version, Confidence.HIGHEST);
                if (id.indexOf(46) > 0) {
                    String[] parts = id.split("\\.");
                    child.addEvidence(EvidenceType.VENDOR, "msbuild", "id", parts[0], Confidence.MEDIUM);
                    child.addEvidence(EvidenceType.PRODUCT, "msbuild", "id", parts[1], Confidence.MEDIUM);
                    if (parts.length > 2) {
                        String rest = id.substring(id.indexOf(46) + 1);
                        child.addEvidence(EvidenceType.PRODUCT, "msbuild", "id", rest, Confidence.MEDIUM);
                    }
                } else {
                    child.addEvidence(EvidenceType.VENDOR, "msbuild", "id", id, Confidence.LOW);
                }
                engine.addDependency(child);
            }
        }
        catch (Throwable e) {
            throw new AnalysisException(e);
        }
    }

    private Properties loadDirectoryBuildProps(File directory) throws MSBuildProjectParseException {
        Map<String, String> entries;
        Properties props = new Properties();
        if (directory == null || !directory.isDirectory()) {
            return props;
        }
        File directoryProps = this.locateDirectoryBuildFile(DIRECTORY_BUILDPROPS, directory);
        if (directoryProps != null && (entries = this.readDirectoryBuildProps(directoryProps)) != null) {
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                props.put(entry.getKey(), entry.getValue());
            }
        }
        return props;
    }

    private File locateDirectoryBuildFile(String name, File directory) {
        for (File search = directory; search != null && search.isDirectory(); search = search.getParentFile()) {
            File props = new File(search, name);
            if (!props.isFile()) continue;
            return props;
        }
        return null;
    }

    private File getImport(String importStatement, File currentFile) {
        if (importStatement == null || importStatement.isEmpty()) {
            return null;
        }
        if (importStatement.startsWith("$")) {
            String compact = importStatement.replaceAll("\\s", "");
            if (IMPORT_GET_PATH_OF_FILE.equalsIgnoreCase(compact) || IMPORT_GET_DIRECTORY.equalsIgnoreCase(compact)) {
                return this.locateDirectoryBuildFile(DIRECTORY_BUILDPROPS, currentFile.getParentFile().getParentFile());
            }
            if (importStatement.startsWith("$(MSBuildThisFileDirectory)")) {
                String path = importStatement.substring(27);
                File currentDirectory = currentFile.getParentFile();
                Path p = Paths.get(currentDirectory.getAbsolutePath(), path.replace('\\', File.separatorChar).replace('/', File.separatorChar));
                File f = p.normalize().toFile();
                if (f.isFile() && !f.equals(currentFile)) {
                    return f;
                }
            }
        } else {
            File currentDirectory = currentFile.getParentFile();
            Path p = Paths.get(currentDirectory.getAbsolutePath(), importStatement.replace('\\', File.separatorChar).replace('/', File.separatorChar));
            File f = p.normalize().toFile();
            if (f.isFile() && !f.equals(currentFile)) {
                return f;
            }
        }
        LOGGER.warn("Unable to import Directory.Build.props import `{}` in `{}`", (Object)importStatement, (Object)currentFile);
        return null;
    }

    private Map<String, String> readDirectoryBuildProps(File directoryProps) throws MSBuildProjectParseException {
        Map<String, String> entries = null;
        HashSet<String> imports = new HashSet<String>();
        if (directoryProps != null && directoryProps.isFile()) {
            DirectoryBuildPropsParser parser = new DirectoryBuildPropsParser();
            try (FileInputStream fis = new FileInputStream(directoryProps);
                 BOMInputStream bis = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream((InputStream)fis)).get();){
                bis.getBOM();
                entries = parser.parse((InputStream)bis);
                imports.addAll(parser.getImports());
            }
            catch (IOException ex) {
                throw new MSBuildProjectParseException("Error reading Directory.Build.props", ex);
            }
            for (String importStatement : imports) {
                Map<String, String> parentEntries;
                File parentBuildProps = this.getImport(importStatement, directoryProps);
                if (parentBuildProps == null || directoryProps.equals(parentBuildProps) || (parentEntries = this.readDirectoryBuildProps(parentBuildProps)) == null) continue;
                parentEntries.putAll(entries);
                entries = parentEntries;
            }
            return entries;
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> loadCentrallyManaged(File folder, Properties props) throws MSBuildProjectParseException {
        File packages = this.locateDirectoryBuildFile(DIRECTORY_PACKAGESPROPS, folder);
        if (packages != null && packages.isFile()) {
            DirectoryPackagesPropsParser parser = new DirectoryPackagesPropsParser();
            try (FileInputStream fis = new FileInputStream(packages);){
                Map<String, String> map;
                block14: {
                    BOMInputStream bis = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream((InputStream)fis)).get();
                    try {
                        bis.getBOM();
                        map = parser.parse((InputStream)bis, props);
                        if (bis == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (bis != null) {
                            try {
                                bis.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    bis.close();
                }
                return map;
            }
            catch (IOException ex) {
                throw new MSBuildProjectParseException("Error reading Directory.Build.props", ex);
            }
        }
        return new HashMap<String, String>();
    }
}

