/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.cisa;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import com.fasterxml.jackson.module.blackbird.BlackbirdModule;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipException;
import org.owasp.dependencycheck.data.knownexploited.json.KnownExploitedVulnerabilitiesSchema;
import org.owasp.dependencycheck.data.update.exception.CorruptedDatastreamException;
import org.owasp.dependencycheck.data.update.exception.UpdateException;
import org.owasp.dependencycheck.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnownExploitedVulnerabilityParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnownExploitedVulnerabilityParser.class);

    /*
     * Enabled aggressive exception aggregation
     */
    public KnownExploitedVulnerabilitiesSchema parse(InputStream in) throws UpdateException, CorruptedDatastreamException {
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object module = Utils.getJavaVersion() <= 8 ? new AfterburnerModule() : new BlackbirdModule();
        objectMapper.registerModule((Module)module);
        ObjectReader objectReader = objectMapper.readerFor(KnownExploitedVulnerabilitiesSchema.class);
        try (InputStreamReader isr = new InputStreamReader(in, StandardCharsets.UTF_8);){
            KnownExploitedVulnerabilitiesSchema knownExploitedVulnerabilitiesSchema;
            block14: {
                JsonParser parser = objectReader.getFactory().createParser((Reader)isr);
                try {
                    KnownExploitedVulnerabilitiesSchema data;
                    knownExploitedVulnerabilitiesSchema = data = (KnownExploitedVulnerabilitiesSchema)objectReader.readValue(parser);
                    if (parser == null) break block14;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return knownExploitedVulnerabilitiesSchema;
        }
        catch (EOFException | ZipException ex) {
            throw new CorruptedDatastreamException("Error parsing CISA Known Exploited Vulnerabilities file", ex);
        }
        catch (IOException ex) {
            LOGGER.error("Error reading CISA Known Exploited Vulnerabilities JSON data");
            LOGGER.debug("Error extracting the CISA Known Exploited Vulnerabilities JSON data", (Throwable)ex);
            throw new UpdateException("Unable to find the CISA Known Exploited Vulnerabilities file to parse", ex);
        }
    }
}

