/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractNpmAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.SearchException;
import org.owasp.dependencycheck.analyzer.exception.UnexpectedAnalysisException;
import org.owasp.dependencycheck.data.nodeaudit.Advisory;
import org.owasp.dependencycheck.data.nodeaudit.NpmPayloadBuilder;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.URLConnectionFailureException;
import org.owasp.dependencycheck.utils.processing.ProcessReader;
import org.semver4j.Semver;
import org.semver4j.SemverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import us.springett.parsers.cpe.exceptions.CpeValidationException;

@ThreadSafe
public class YarnAuditAnalyzer
extends AbstractNpmAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(YarnAuditAnalyzer.class);
    private static final int YARN_CLASSIC_MAJOR_VERSION = 1;
    public static final String YARN_PACKAGE_LOCK = "yarn.lock";
    private static final FileFilter LOCK_FILE_FILTER = FileFilterBuilder.newInstance().addFilenames("yarn.lock").build();
    private static final String EXPECTED_ERROR = "{\"type\":\"error\",\"data\":\"Can't make a request in offline mode (\\\"https://registry.yarnpkg.com/-/npm/v1/security/audits\\\")\"}\n";
    private String yarnPath;

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.yarn.audit.enabled";
    }

    @Override
    protected FileFilter getFileFilter() {
        return LOCK_FILE_FILTER;
    }

    @Override
    public String getName() {
        return "Yarn Audit Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINDING_ANALYSIS;
    }

    private int getYarnMajorVersion(Dependency dependency) {
        String yarnVersion = this.getYarnVersion(dependency);
        try {
            Semver semver = Semver.coerce((String)yarnVersion);
            return semver.getMajor();
        }
        catch (SemverException e) {
            throw new IllegalStateException("Invalid version string format", e);
        }
    }

    private String getYarnVersion(Dependency dependency) {
        String string;
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getYarn());
        args.add("--version");
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.directory(YarnAuditAnalyzer.getDependencyDirectory(dependency));
        LOGGER.debug("Launching: {}", args);
        Process process = builder.start();
        ProcessReader processReader = new ProcessReader(process);
        try {
            processReader.readAll();
            int exitValue = process.waitFor();
            if (exitValue != 0) {
                throw new IllegalStateException("Unable to determine yarn version, unexpected response.");
            }
            String yarnVersion = processReader.getOutput();
            if (StringUtils.isBlank((CharSequence)yarnVersion)) {
                throw new IllegalStateException("Unable to determine yarn version, blank output.");
            }
            string = yarnVersion;
        }
        catch (Throwable throwable) {
            try {
                try {
                    processReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to determine yarn version.", ex);
            }
        }
        processReader.close();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
        super.prepareFileTypeAnalyzer(engine);
        if (!this.isEnabled()) {
            LOGGER.debug("{} Analyzer is disabled skipping yarn executable check", (Object)this.getName());
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getYarn());
        args.add("--help");
        ProcessBuilder builder = new ProcessBuilder(args);
        LOGGER.debug("Launching: {}", args);
        try {
            Process process = builder.start();
            try (ProcessReader processReader = new ProcessReader(process);){
                processReader.readAll();
                int exitValue = process.waitFor();
                boolean expectedExitValue = false;
                int yarnExecutableNotFoundExitValue = 127;
                switch (exitValue) {
                    case 0: {
                        LOGGER.debug("{} is enabled.", (Object)this.getName());
                        return;
                    }
                    default: {
                        this.setEnabled(false);
                        LOGGER.warn("The {} has been disabled. Yarn executable was not found.", (Object)this.getName());
                        return;
                    }
                }
            }
        }
        catch (Exception ex) {
            this.setEnabled(false);
            LOGGER.warn("The {} has been disabled. Yarn executable was not found.", (Object)this.getName());
            throw new InitializationException("Unable to read yarn audit output.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getYarn() {
        String value;
        YarnAuditAnalyzer yarnAuditAnalyzer = this;
        synchronized (yarnAuditAnalyzer) {
            if (this.yarnPath == null) {
                String path = this.getSettings().getString("analyzer.yarn.path");
                if (path == null) {
                    this.yarnPath = "yarn";
                } else {
                    File yarnFile = new File(path);
                    if (yarnFile.isFile()) {
                        this.yarnPath = yarnFile.getAbsolutePath();
                    } else {
                        LOGGER.warn("Provided path to `yarn` executable is invalid.");
                        this.yarnPath = "yarn";
                    }
                }
            }
            value = this.yarnPath;
        }
        return value;
    }

    private String startAndReadStdoutToString(ProcessBuilder builder) throws AnalysisException {
        String string;
        File tmpFile = this.getSettings().getTempFile("yarn_audit", "json");
        builder.redirectOutput(tmpFile);
        Process process = builder.start();
        ProcessReader processReader = new ProcessReader(process);
        try {
            processReader.readAll();
            String errOutput = processReader.getError();
            if (!StringUtils.isBlank((CharSequence)errOutput) && !EXPECTED_ERROR.equals(errOutput)) {
                LOGGER.debug("Process Error Out: {}", (Object)errOutput);
                LOGGER.debug("Process Out: {}", (Object)processReader.getOutput());
            }
            string = new String(Files.readAllBytes(tmpFile.toPath()), StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        processReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new AnalysisException("Yarn audit process was interrupted.", ex);
                }
            }
            catch (IOException ioe) {
                throw new AnalysisException("yarn audit failure; this error can be ignored if you are not analyzing projects with a yarn lockfile.", ioe);
            }
        }
        processReader.close();
        return string;
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        List<Advisory> advisories;
        File packageLock;
        if (dependency.getDisplayFileName().equals(dependency.getFileName())) {
            engine.removeDependency(dependency);
        }
        if (!(packageLock = dependency.getActualFile()).isFile() || packageLock.length() == 0L || !YarnAuditAnalyzer.shouldProcess(packageLock)) {
            return;
        }
        File packageJson = new File(packageLock.getParentFile(), "package.json");
        HashSetValuedHashMap dependencyMap = new HashSetValuedHashMap();
        int yarnMajorVersion = this.getYarnMajorVersion(dependency);
        if (1 < yarnMajorVersion) {
            LOGGER.info("Analyzing using Yarn Berry audit");
            advisories = this.analyzePackageWithYarnBerry(dependency);
        } else {
            LOGGER.info("Analyzing using Yarn Classic audit");
            advisories = this.analyzePackageWithYarnClassic(packageLock, packageJson, dependency, (MultiValuedMap<String, String>)dependencyMap);
        }
        try {
            this.processResults(advisories, engine, dependency, (MultiValuedMap<String, String>)dependencyMap);
        }
        catch (CpeValidationException ex) {
            throw new UnexpectedAnalysisException(ex);
        }
    }

    private JsonObject fetchYarnAuditJson(Dependency dependency, boolean skipDevDependencies) throws AnalysisException {
        String auditRequest;
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getYarn());
        args.add("audit");
        args.add("--offline");
        if (skipDevDependencies) {
            args.add("--groups");
            args.add("dependencies");
        }
        args.add("--json");
        args.add("--verbose");
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.directory(YarnAuditAnalyzer.getDependencyDirectory(dependency));
        LOGGER.debug("Launching: {}", args);
        String verboseJson = this.startAndReadStdoutToString(builder);
        String auditRequestJson = Arrays.stream(verboseJson.split("\n")).filter(line -> line.contains("Audit Request")).findFirst().get();
        try (JsonReader reader = Json.createReader((InputStream)IOUtils.toInputStream((String)auditRequestJson, (Charset)StandardCharsets.UTF_8));){
            JsonObject jsonObject = reader.readObject();
            auditRequest = jsonObject.getString("data");
            auditRequest = auditRequest.substring(15);
        }
        LOGGER.debug("Audit Request: {}", (Object)auditRequest);
        return Json.createReader((InputStream)IOUtils.toInputStream((String)auditRequest, (Charset)StandardCharsets.UTF_8)).readObject();
    }

    private static File getDependencyDirectory(Dependency dependency) {
        File folder = dependency.getActualFile().getParentFile();
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException(String.format("%s should have been a directory.", folder.getAbsolutePath()));
        }
        return folder;
    }

    private List<Advisory> analyzePackageWithYarnClassic(File lockFile, File packageFile, Dependency dependency, MultiValuedMap<String, String> dependencyMap) throws AnalysisException {
        try {
            JsonObject packageJson;
            boolean skipDevDependencies = this.getSettings().getBoolean("analyzer.node.audit.skipdev", false);
            JsonObject lockJson = this.fetchYarnAuditJson(dependency, skipDevDependencies);
            try (JsonReader packageReader = Json.createReader((InputStream)Files.newInputStream(packageFile.toPath(), new OpenOption[0]));){
                packageJson = packageReader.readObject();
            }
            JsonObject payload = NpmPayloadBuilder.build(lockJson, packageJson, dependencyMap, skipDevDependencies);
            return this.getSearcher().submitPackage(payload);
        }
        catch (URLConnectionFailureException e) {
            this.setEnabled(false);
            throw new AnalysisException("Failed to connect to the NPM Audit API (YarnAuditAnalyzer); the analyzer is being disabled and may result in false negatives.", e);
        }
        catch (IOException e) {
            LOGGER.debug("Error reading dependency or connecting to NPM Audit API", (Throwable)e);
            this.setEnabled(false);
            throw new AnalysisException("Failed to read results from the NPM Audit API (YarnAuditAnalyzer); the analyzer is being disabled and may result in false negatives.", e);
        }
        catch (JsonException e) {
            throw new AnalysisException(String.format("Failed to parse %s file from the NPM Audit API (YarnAuditAnalyzer).", lockFile.getPath()), e);
        }
        catch (SearchException ex) {
            LOGGER.error("YarnAuditAnalyzer failed on {}", (Object)dependency.getActualFilePath());
            throw ex;
        }
    }

    private List<JSONObject> fetchYarnAdvisories(Dependency dependency, boolean skipDevDependencies) throws AnalysisException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.getYarn());
        args.add("npm");
        args.add("audit");
        if (skipDevDependencies) {
            args.add("--environment");
            args.add("production");
        }
        args.add("--all");
        args.add("--recursive");
        args.add("--json");
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.directory(YarnAuditAnalyzer.getDependencyDirectory(dependency));
        String advisoriesJsons = this.startAndReadStdoutToString(builder);
        LOGGER.debug("Advisories JSON: {}", (Object)advisoriesJsons);
        String[] advisoriesJsonArray = (String[])Stream.of(advisoriesJsons.split("\n")).filter(s -> !s.isBlank()).toArray(String[]::new);
        try {
            ArrayList<JSONObject> advisories = new ArrayList<JSONObject>();
            for (String advisoriesJson : advisoriesJsonArray) {
                advisories.add(new JSONObject(advisoriesJson));
            }
            return advisories;
        }
        catch (JSONException e) {
            throw new AnalysisException("Failed to parse the response from NPM Audit API (YarnBerryAuditAnalyzer).", e);
        }
    }

    private List<Advisory> analyzePackageWithYarnBerry(Dependency dependency) throws AnalysisException {
        try {
            boolean skipDevDependencies = this.getSettings().getBoolean("analyzer.node.audit.skipdev", false);
            List<JSONObject> advisoryJsons = this.fetchYarnAdvisories(dependency, skipDevDependencies);
            return YarnAuditAnalyzer.parseAdvisoryJsons(advisoryJsons);
        }
        catch (JSONException e) {
            throw new AnalysisException("Failed to parse the response from NPM Audit API (YarnBerryAuditAnalyzer).", e);
        }
        catch (SearchException ex) {
            LOGGER.error("YarnBerryAuditAnalyzer failed on {}", (Object)dependency.getActualFilePath());
            throw ex;
        }
    }

    private static List<Advisory> parseAdvisoryJsons(List<JSONObject> advisoryJsons) throws JSONException {
        ArrayList<Advisory> advisories = new ArrayList<Advisory>();
        for (JSONObject advisoryJson : advisoryJsons) {
            Advisory advisory = new Advisory();
            JSONObject object = advisoryJson.getJSONObject("children");
            String moduleName = advisoryJson.optString("value", null);
            String id = object.getString("ID");
            String url = object.optString("URL", null);
            String ghsaId = YarnAuditAnalyzer.extractGhsaId(url);
            String issue = object.optString("Issue", null);
            String severity = object.optString("Severity", null);
            String vulnerableVersions = object.optString("Vulnerable Versions", null);
            JSONArray treeVersions = object.optJSONArray("Tree Versions");
            int treeVersionsLength = treeVersions == null ? 0 : treeVersions.length();
            ArrayList<String> versions = new ArrayList<String>();
            for (int i = 0; i < treeVersionsLength; ++i) {
                versions.add(treeVersions.getString(i));
            }
            if (versions.isEmpty()) {
                versions.add(null);
            }
            for (String version : versions) {
                advisory.setGhsaId(ghsaId);
                advisory.setTitle(issue);
                advisory.setOverview("URL:" + url + "ID: " + id);
                advisory.setSeverity(severity);
                advisory.setVulnerableVersions(vulnerableVersions);
                advisory.setModuleName(moduleName);
                advisory.setVersion(version);
                advisory.setCwes(new ArrayList<String>());
                advisories.add(advisory);
            }
        }
        return advisories;
    }

    private static String extractGhsaId(String url) {
        if (url == null || url.isEmpty()) {
            return null;
        }
        int lastSlashIndex = url.lastIndexOf(47);
        if (lastSlashIndex == -1 || lastSlashIndex == url.length() - 1) {
            return null;
        }
        return url.substring(lastSlashIndex + 1);
    }
}

