/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.dependency.naming;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.naming.Identifier;

public class PurlIdentifier
implements Identifier {
    private static final long serialVersionUID = 8371122848306175579L;
    private final PackageURL purl;
    private Confidence confidence;
    private String url;
    private String notes;

    public PurlIdentifier(PackageURL purl, Confidence confidence) {
        this.purl = purl;
        this.confidence = confidence;
        this.url = null;
    }

    public PurlIdentifier(PackageURL purl, String url, Confidence confidence) {
        this.purl = purl;
        this.confidence = confidence;
        this.url = url;
    }

    public PurlIdentifier(String type, String name, String version, Confidence confidence) throws MalformedPackageURLException {
        this.purl = PackageURLBuilder.aPackageURL().withType(type).withName(name).withVersion(version).build();
        this.confidence = confidence;
    }

    public PurlIdentifier(String type, String namespace, String name, String version, Confidence confidence) throws MalformedPackageURLException {
        this.purl = PackageURLBuilder.aPackageURL().withType(type).withNamespace(namespace).withName(name).withVersion(version).build();
        this.confidence = confidence;
    }

    @Override
    public Confidence getConfidence() {
        return this.confidence;
    }

    @Override
    public String getNotes() {
        return this.notes;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setConfidence(Confidence confidence) {
        this.confidence = confidence;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String toString() {
        return this.purl.canonicalize();
    }

    @Override
    public String getValue() {
        return this.purl.canonicalize();
    }

    public String getNamespace() {
        return this.purl.getNamespace();
    }

    public String getName() {
        return this.purl.getName();
    }

    public String getVersion() {
        return this.purl.getVersion();
    }

    public String toGav() {
        if (this.purl.getNamespace() != null && this.purl.getVersion() != null) {
            return String.format("%s:%s:%s", this.purl.getNamespace(), this.purl.getName(), this.purl.getVersion());
        }
        return null;
    }

    @Override
    public int compareTo(@NotNull Identifier o) {
        if (o instanceof PurlIdentifier) {
            PurlIdentifier other = (PurlIdentifier)o;
            return new CompareToBuilder().append((Object)this.purl.canonicalize(), (Object)other.purl.canonicalize()).append((Object)this.url, (Object)other.getUrl()).append((Object)this.confidence, (Object)other.getConfidence()).toComparison();
        }
        return new CompareToBuilder().append((Object)this.toString(), (Object)o.toString()).append((Object)this.url, (Object)o.getUrl()).append((Object)this.confidence, (Object)o.getConfidence()).toComparison();
    }

    public int hashCode() {
        return new HashCodeBuilder(93, 187).append((Object)this.purl).append((Object)this.confidence).append((Object)this.url).append((Object)this.notes).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PurlIdentifier)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PurlIdentifier other = (PurlIdentifier)obj;
        return new EqualsBuilder().append((Object)this.purl, (Object)other.purl).append((Object)this.confidence, (Object)other.confidence).append((Object)this.url, (Object)other.url).append((Object)this.notes, (Object)other.notes).isEquals();
    }
}

