/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.reporting;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.text.StringEscapeUtils;
import org.owasp.dependencycheck.dependency.naming.Identifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class EscapeTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(EscapeTool.class);

    public String url(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        try {
            return URLEncoder.encode(text, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.warn("UTF-8 is not supported?");
            LOGGER.info("", (Throwable)ex);
            return "";
        }
    }

    public String html(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return StringEscapeUtils.escapeHtml4((String)text);
    }

    public String xml(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return StringEscapeUtils.escapeXml11((String)text);
    }

    public String json(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return StringEscapeUtils.escapeJson((String)text);
    }

    public String javascript(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        return StringEscapeUtils.escapeEcmaScript((String)text);
    }

    public String csv(String text) {
        if (text == null || text.isEmpty()) {
            return "\"\"";
        }
        String str = text.trim().replace("\n", " ");
        if (str.trim().length() == 0) {
            return "\"\"";
        }
        return StringEscapeUtils.escapeCsv((String)str);
    }

    public String csvIdentifiers(Set<Identifier> ids) {
        if (ids == null || ids.isEmpty()) {
            return "\"\"";
        }
        boolean addComma = false;
        StringBuilder sb = new StringBuilder();
        for (Identifier id : ids) {
            if (addComma) {
                sb.append(", ");
            } else {
                addComma = true;
            }
            sb.append(id.getValue());
        }
        if (sb.length() == 0) {
            return "\"\"";
        }
        return StringEscapeUtils.escapeCsv((String)sb.toString());
    }

    public String csvCpeConfidence(Set<Identifier> ids) {
        if (ids == null || ids.isEmpty()) {
            return "\"\"";
        }
        boolean addComma = false;
        StringBuilder sb = new StringBuilder();
        for (Identifier id : ids) {
            if (addComma) {
                sb.append(", ");
            } else {
                addComma = true;
            }
            sb.append((Object)id.getConfidence());
        }
        if (sb.length() == 0) {
            return "\"\"";
        }
        return StringEscapeUtils.escapeCsv((String)sb.toString());
    }
}

