/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.ossindex;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.sonatype.ossindex.service.client.OssindexClientConfiguration;
import org.sonatype.ossindex.service.client.transport.AuthConfiguration;
import org.sonatype.ossindex.service.client.transport.BasicAuthHelper;
import org.sonatype.ossindex.service.client.transport.HttpUrlConnectionTransport;
import org.sonatype.ossindex.service.client.transport.UserAgentSupplier;

public class ODCConnectionTransport
extends HttpUrlConnectionTransport {
    private final OssindexClientConfiguration configuration;
    private final URLConnectionFactory connectionFactory;
    private final UserAgentSupplier userAgent;

    public ODCConnectionTransport(Settings settings, OssindexClientConfiguration config, UserAgentSupplier userAgent) {
        super(userAgent);
        this.userAgent = (UserAgentSupplier)Preconditions.checkNotNull((Object)userAgent);
        this.configuration = (OssindexClientConfiguration)Preconditions.checkNotNull((Object)config);
        this.connectionFactory = new URLConnectionFactory(settings);
    }

    protected HttpURLConnection connect(URL url) throws IOException {
        HttpURLConnection connection = this.connectionFactory.createHttpURLConnection(url);
        connection.setRequestProperty("User-Agent", this.userAgent.get());
        String authorization = BasicAuthHelper.authorizationHeader((AuthConfiguration)this.configuration.getAuthConfiguration());
        if (authorization != null) {
            connection.setRequestProperty("Authorization", authorization);
        }
        return connection;
    }
}

