/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.golang;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.stream.JsonParsingException;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.golang.GoModDependency;
import org.owasp.dependencycheck.utils.JsonArrayFixingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class GoModJsonParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoModJsonParser.class);

    private GoModJsonParser() {
    }

    public static List<GoModDependency> process(InputStream inputStream) throws AnalysisException {
        LOGGER.debug("Beginning go.mod processing");
        ArrayList<GoModDependency> goModDependencies = new ArrayList<GoModDependency>();
        try (JsonArrayFixingInputStream jsonStream = new JsonArrayFixingInputStream(inputStream);
             JsonReader reader = Json.createReader((InputStream)jsonStream);){
            JsonArray modules = reader.readArray();
            for (JsonObject module : modules.getValuesAs(JsonObject.class)) {
                String path = module.getString("Path");
                String version = module.getString("Version", null);
                if (version != null && version.startsWith("v")) {
                    version = version.substring(1);
                }
                goModDependencies.add(new GoModDependency(path, version));
            }
        }
        catch (JsonParsingException jsonpe) {
            throw new AnalysisException("Error parsing stream", jsonpe);
        }
        catch (JsonException jsone) {
            throw new AnalysisException("Error reading stream", jsone);
        }
        catch (IllegalStateException ise) {
            throw new AnalysisException("Illegal state in go mod stream", ise);
        }
        catch (ClassCastException cce) {
            throw new AnalysisException("JSON not exactly matching output of `go list -json -m all`", cce);
        }
        catch (IOException ex) {
            throw new AnalysisException("Error reading output of `go list -json -m all`", ex);
        }
        return goModDependencies;
    }
}

