/*
 * This file is part of dependency-check-core.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Copyright (c) 2019 Jeremy Long. All Rights Reserved.
 */
package org.owasp.dependencycheck.xml.assembly;

import java.util.ArrayList;
import java.util.List;

/**
 * A simple collection of .NET assembly data as collected from GrokAssembly.
 *
 * @author Jeremy Long
 */
public class AssemblyData {

    /**
     * Processing error generated by GrokAssembly.
     */
    private String error;
    /**
     * Processing warning message generated by GrokAssembly.
     */
    private String warning;
    /**
     * The company name.
     */
    private String companyName;
    /**
     * The product name.
     */
    private String productName;
    /**
     * The product version.
     */
    private String productVersion;
    /**
     * The comments.
     */
    private String comments;
    /**
     * The file description.
     */
    private String fileDescription;
    /**
     * The file name.
     */
    private String fileName;
    /**
     * The file version.
     */
    private String fileVersion;
    /**
     * The internal name.
     */
    private String internalName;
    /**
     * The legal copyright.
     */
    private String legalCopyright;
    /**
     * The legal trademarks.
     */
    private String legalTrademarks;
    /**
     * The original file name.
     */
    private String originalFilename;
    /**
     * The full name.
     */
    private String fullName;
    /**
     * A list of namespace within the assembly.
     */
    private final List<String> namespaces = new ArrayList<>();

    /**
     * Get the value of error.
     *
     * @return the value of error
     */
    public String getError() {
        return error;
    }

    /**
     * Set the value of error.
     *
     * @param error new value of error
     */
    public void setError(String error) {
        this.error = error;
    }

    /**
     * Get the value of companyName.
     *
     * @return the value of companyName
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * Set the value of companyName.
     *
     * @param companyName new value of companyName
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * Get the value of productName.
     *
     * @return the value of productName
     */
    public String getProductName() {
        return productName;
    }

    /**
     * Set the value of productName.
     *
     * @param productName new value of productName
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * Get the value of productVersion.
     *
     * @return the value of productVersion
     */
    public String getProductVersion() {
        return productVersion;
    }

    /**
     * Set the value of productVersion.
     *
     * @param productVersion new value of productVersion
     */
    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    /**
     * Get the value of comments.
     *
     * @return the value of comments
     */
    public String getComments() {
        return comments;
    }

    /**
     * Set the value of comments.
     *
     * @param comments new value of comments
     */
    public void setComments(String comments) {
        this.comments = comments;
    }

    /**
     * Get the value of fileDescription.
     *
     * @return the value of fileDescription
     */
    public String getFileDescription() {
        return fileDescription;
    }

    /**
     * Set the value of fileDescription.
     *
     * @param fileDescription new value of fileDescription
     */
    public void setFileDescription(String fileDescription) {
        this.fileDescription = fileDescription;
    }

    /**
     * Get the value of fileName.
     *
     * @return the value of fileName
     */
    public String getFileName() {
        return fileName;
    }

    /**
     * Set the value of fileName.
     *
     * @param fileName new value of fileName
     */
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    /**
     * Get the value of fileVersion.
     *
     * @return the value of fileVersion
     */
    public String getFileVersion() {
        return fileVersion;
    }

    /**
     * Set the value of fileVersion.
     *
     * @param fileVersion new value of fileVersion
     */
    public void setFileVersion(String fileVersion) {
        this.fileVersion = fileVersion;
    }

    /**
     * Get the value of internalName.
     *
     * @return the value of internalName
     */
    public String getInternalName() {
        return internalName;
    }

    /**
     * Set the value of internalName.
     *
     * @param internalName new value of internalName
     */
    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    /**
     * Get the value of legalCopyright.
     *
     * @return the value of legalCopyright
     */
    public String getLegalCopyright() {
        return legalCopyright;
    }

    /**
     * Set the value of legalCopyright.
     *
     * @param legalCopyright new value of legalCopyright
     */
    public void setLegalCopyright(String legalCopyright) {
        this.legalCopyright = legalCopyright;
    }

    /**
     * Get the value of legalTrademarks.
     *
     * @return the value of legalTrademarks
     */
    public String getLegalTrademarks() {
        return legalTrademarks;
    }

    /**
     * Set the value of legalTrademarks.
     *
     * @param legalTrademarks new value of legalTrademarks
     */
    public void setLegalTrademarks(String legalTrademarks) {
        this.legalTrademarks = legalTrademarks;
    }

    /**
     * Get the value of originalFilename.
     *
     * @return the value of originalFilename
     */
    public String getOriginalFilename() {
        return originalFilename;
    }

    /**
     * Set the value of originalFilename.
     *
     * @param originalFilename new value of originalFilename
     */
    public void setOriginalFilename(String originalFilename) {
        this.originalFilename = originalFilename;
    }

    /**
     * Get the value of fullName.
     *
     * @return the value of fullName
     */
    public String getFullName() {
        return fullName;
    }

    /**
     * Set the value of fullName.
     *
     * @param fullName new value of fullName
     */
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    /**
     * Get the value of namespaces.
     *
     * @return the value of namespaces
     */
    public List<String> getNamespaces() {
        return namespaces;
    }

    /**
     * Adds a name space.
     *
     * @param namespace the namespace to add
     */
    public void addNamespace(String namespace) {
        this.namespaces.add(namespace);
    }

    /**
     * Get the value of warning.
     *
     * @return the value of warning
     */
    public String getWarning() {
        return warning;
    }

    /**
     * Set the value of warning.
     *
     * @param warning new value of warning
     */
    public void setWarning(String warning) {
        this.warning = warning;
    }

}
