/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.xml.suppression;

import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@ThreadSafe
public class PropertyType {
    private String value;
    private boolean regex = false;
    private boolean caseSensitive = false;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isRegex() {
        return this.regex;
    }

    public void setRegex(boolean value) {
        this.regex = value;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean value) {
        this.caseSensitive = value;
    }

    public boolean matches(String text) {
        if (text == null) {
            return false;
        }
        if (this.regex) {
            Pattern rx = this.caseSensitive ? Pattern.compile(this.value) : Pattern.compile(this.value, 2);
            return rx.matcher(text).matches();
        }
        if (this.caseSensitive) {
            return this.value.equals(text);
        }
        return this.value.equalsIgnoreCase(text);
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 59).append((Object)this.value).append(this.regex).append(this.caseSensitive).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PropertyType)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        PropertyType rhs = (PropertyType)obj;
        return new EqualsBuilder().append((Object)this.value, (Object)rhs.value).append(this.regex, rhs.regex).append(this.caseSensitive, rhs.caseSensitive).isEquals();
    }

    public String toString() {
        return "PropertyType{value=" + this.value + ", regex=" + this.regex + ", caseSensitive=" + this.caseSensitive + '}';
    }
}

