/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.utils.Checksum;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class DartAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DartAnalyzer.class);
    private static final String LOCK_FILE = "pubspec.lock";
    private static final String YAML_FILE = "pubspec.yaml";

    @Override
    protected FileFilter getFileFilter() {
        return FileFilterBuilder.newInstance().addFilenames(LOCK_FILE, YAML_FILE).build();
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) {
    }

    @Override
    public String getName() {
        return "Dart Package Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.dart.enabled";
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        String fileName = dependency.getFileName();
        LOGGER.debug("Checking file {}", (Object)fileName);
        switch (fileName) {
            case "pubspec.lock": {
                this.analyzeLockFileDependencies(dependency, engine);
                break;
            }
            case "pubspec.yaml": {
                this.analyzeYamlFileDependencies(dependency, engine);
                break;
            }
        }
    }

    private void analyzeYamlFileDependencies(Dependency yamlFileDependency, Engine engine) throws AnalysisException {
        JsonNode rootNode;
        File lock;
        engine.removeDependency(yamlFileDependency);
        File yamlFile = yamlFileDependency.getActualFile();
        if (YAML_FILE.equals(yamlFile.getName()) && (lock = new File(yamlFile.getParentFile(), LOCK_FILE)).isFile()) {
            LOGGER.debug("Skipping {} because {} exists", (Object)yamlFile, (Object)lock);
            return;
        }
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            rootNode = objectMapper.readTree(yamlFile);
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        if (rootNode.hasNonNull("dependencies")) {
            Iterator dependencies = rootNode.get("dependencies").fields();
            this.addYamlDependenciesToEngine(dependencies, yamlFile, engine);
        }
        if (rootNode.hasNonNull("dev_dependencies")) {
            Iterator devDependencies = rootNode.get("dev_dependencies").fields();
            this.addYamlDependenciesToEngine(devDependencies, yamlFile, engine);
        }
        this.addYamlDartDependencyToEngine(rootNode, yamlFile, engine);
    }

    private void analyzeLockFileDependencies(Dependency lockFileDependency, Engine engine) throws AnalysisException {
        JsonNode rootNode;
        engine.removeDependency(lockFileDependency);
        File lockFile = lockFileDependency.getActualFile();
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            rootNode = objectMapper.readTree(lockFile);
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency lockFile.", e);
        }
        this.addLockFileDependenciesToEngine(lockFile, engine, rootNode);
        this.addLockFileDartVersionToEngine(lockFile, engine, rootNode);
    }

    private void addLockFileDartVersionToEngine(File file, Engine engine, JsonNode rootNode) throws AnalysisException {
        String dartVersion = rootNode.get("sdks").get("dart").textValue();
        String minimumVersion = this.extractMinimumVersion(dartVersion);
        engine.addDependency(this.createDependencyFromNameAndVersion(file, "dart_software_development_kit", minimumVersion));
    }

    private void addLockFileDependenciesToEngine(File file, Engine engine, JsonNode rootNode) throws AnalysisException {
        for (JsonNode nextPackage : rootNode.get("packages")) {
            JsonNode versionNode;
            JsonNode nameNode;
            JsonNode description = nextPackage.get("description");
            if (description == null || (nameNode = description.get("name")) == null || (versionNode = nextPackage.get("version")) == null) continue;
            String name = nameNode.asText();
            String version = versionNode.asText();
            LOGGER.debug("Found dependency in {} file, name: {}, version: {}", new Object[]{LOCK_FILE, name, version});
            engine.addDependency(this.createDependencyFromNameAndVersion(file, name, version));
        }
    }

    private void addYamlDependenciesToEngine(Iterator<Map.Entry<String, JsonNode>> dependencies, File file, Engine engine) throws AnalysisException {
        while (dependencies.hasNext()) {
            Map.Entry<String, JsonNode> entry = dependencies.next();
            String name = entry.getKey();
            String versionRaw = entry.getValue().asText();
            String version = this.extractMinimumVersion(versionRaw);
            LOGGER.debug("Found dependency in {} file, name: {}, version: {}", new Object[]{YAML_FILE, name, version});
            engine.addDependency(this.createDependencyFromNameAndVersion(file, name, version));
        }
    }

    private void addYamlDartDependencyToEngine(JsonNode rootNode, File file, Engine engine) throws AnalysisException {
        if (rootNode.hasNonNull("environment") && rootNode.get("environment").hasNonNull("sdk")) {
            String dartVersion = rootNode.get("environment").get("sdk").textValue();
            String minimumVersion = this.extractMinimumVersion(dartVersion);
            engine.addDependency(this.createDependencyFromNameAndVersion(file, "dart_software_development_kit", minimumVersion));
        }
    }

    private Dependency createDependencyFromNameAndVersion(File file, String name, String version) throws AnalysisException {
        PackageURL packageURL;
        Dependency dependency = new Dependency(file, true);
        dependency.setName(name);
        dependency.setVersion(version);
        try {
            packageURL = PackageURLBuilder.aPackageURL().withType("pub").withName(dependency.getName()).withVersion(version.isEmpty() ? null : version).build();
        }
        catch (MalformedPackageURLException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        dependency.addSoftwareIdentifier(new PurlIdentifier(packageURL, Confidence.HIGHEST));
        dependency.addEvidence(EvidenceType.PRODUCT, file.getName(), "name", name, Confidence.HIGHEST);
        dependency.addEvidence(EvidenceType.VENDOR, file.getName(), "name", name, Confidence.HIGHEST);
        dependency.addEvidence(EvidenceType.VENDOR, file.getName(), "name", "dart", Confidence.HIGHEST);
        if (!version.isEmpty()) {
            dependency.addEvidence(EvidenceType.VERSION, file.getName(), "version", version, Confidence.MEDIUM);
        }
        String packagePath = String.format("%s:%s", name, version);
        dependency.setSha1sum(Checksum.getSHA1Checksum((String)packagePath));
        dependency.setSha256sum(Checksum.getSHA256Checksum((String)packagePath));
        dependency.setMd5sum(Checksum.getMD5Checksum((String)packagePath));
        dependency.setPackagePath(packagePath);
        dependency.setDisplayFileName(packagePath);
        return dependency;
    }

    private String extractMinimumVersion(String versionRaw) {
        String version;
        if (versionRaw.contains("^")) {
            version = versionRaw.replace("^", "");
        } else if (versionRaw.contains("<")) {
            String firstPart = versionRaw.split("<")[0].trim();
            version = firstPart.replace(">=", "").trim();
        } else {
            version = versionRaw.contains("any") || "null".equals(versionRaw) ? "" : versionRaw;
        }
        LOGGER.debug("Extracted minimum version: {} from raw version: {}", (Object)version, (Object)versionRaw);
        return version;
    }
}

