/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.central;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.jcs.access.exception.CacheException;
import org.owasp.dependencycheck.data.cache.DataCache;
import org.owasp.dependencycheck.data.cache.DataCacheFactory;
import org.owasp.dependencycheck.data.nexus.MavenArtifact;
import org.owasp.dependencycheck.utils.Settings;
import org.owasp.dependencycheck.utils.TooManyRequestsException;
import org.owasp.dependencycheck.utils.URLConnectionFactory;
import org.owasp.dependencycheck.utils.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@ThreadSafe
public class CentralSearch {
    private final String rootURL;
    private final String query;
    private final boolean useProxy;
    private static final Logger LOGGER = LoggerFactory.getLogger(CentralSearch.class);
    private final Settings settings;
    private DataCache<List<MavenArtifact>> cache;

    public CentralSearch(Settings settings) throws MalformedURLException {
        this.settings = settings;
        String searchUrl = settings.getString("analyzer.central.url");
        LOGGER.debug("Central Search URL: {}", (Object)searchUrl);
        if (this.isInvalidURL(searchUrl)) {
            throw new MalformedURLException(String.format("The configured central analyzer URL is invalid: %s", searchUrl));
        }
        this.rootURL = searchUrl;
        String queryStr = settings.getString("analyzer.central.query");
        LOGGER.debug("Central Search Query: {}", (Object)queryStr);
        if (!queryStr.matches("^%s.*%s.*$")) {
            String msg = String.format("The configured central analyzer query parameter is invalid (it must have two %%s): %s", queryStr);
            throw new MalformedURLException(msg);
        }
        this.query = queryStr;
        LOGGER.debug("Central Search Full URL: {}", (Object)String.format(this.query, this.rootURL, "[SHA1]"));
        if (null != settings.getString("proxy.server")) {
            this.useProxy = true;
            LOGGER.debug("Using proxy");
        } else {
            this.useProxy = false;
            LOGGER.debug("Not using proxy");
        }
        if (settings.getBoolean("analyzer.central.use.cache", true)) {
            try {
                DataCacheFactory factory = new DataCacheFactory(settings);
                this.cache = factory.getCentralCache();
            }
            catch (CacheException ex) {
                settings.setBoolean("analyzer.central.use.cache", false);
                LOGGER.debug("Error creating cache, disabling caching", (Throwable)ex);
            }
        }
    }

    public List<MavenArtifact> searchSha1(String sha1) throws IOException, TooManyRequestsException {
        List<MavenArtifact> cached;
        if (null == sha1 || !sha1.matches("^[0-9A-Fa-f]{40}$")) {
            throw new IllegalArgumentException("Invalid SHA1 format");
        }
        if (this.cache != null && (cached = this.cache.get(sha1)) != null) {
            LOGGER.debug("cache hit for Central: " + sha1);
            if (cached.isEmpty()) {
                throw new FileNotFoundException("Artifact not found in Central");
            }
            return cached;
        }
        ArrayList<MavenArtifact> result = new ArrayList<MavenArtifact>();
        URL url = new URL(String.format(this.query, this.rootURL, sha1));
        LOGGER.trace("Searching Central url {}", (Object)url);
        URLConnectionFactory factory = new URLConnectionFactory(this.settings);
        HttpURLConnection conn = factory.createHttpURLConnection(url, this.useProxy);
        conn.setDoOutput(true);
        conn.addRequestProperty("Accept", "application/xml");
        conn.connect();
        if (conn.getResponseCode() == 200) {
            boolean missing = false;
            try {
                DocumentBuilder builder = XmlUtils.buildSecureDocumentBuilder();
                Document doc = builder.parse(conn.getInputStream());
                XPath xpath = XPathFactory.newInstance().newXPath();
                String numFound = xpath.evaluate("/response/result/@numFound", doc);
                if ("0".equals(numFound)) {
                    missing = true;
                } else {
                    NodeList docs = (NodeList)xpath.evaluate("/response/result/doc", doc, XPathConstants.NODESET);
                    for (int i = 0; i < docs.getLength(); ++i) {
                        String g = xpath.evaluate("./str[@name='g']", docs.item(i));
                        LOGGER.trace("GroupId: {}", (Object)g);
                        String a = xpath.evaluate("./str[@name='a']", docs.item(i));
                        LOGGER.trace("ArtifactId: {}", (Object)a);
                        String v = xpath.evaluate("./str[@name='v']", docs.item(i));
                        NodeList attributes = (NodeList)xpath.evaluate("./arr[@name='ec']/str", docs.item(i), XPathConstants.NODESET);
                        boolean pomAvailable = false;
                        boolean jarAvailable = false;
                        for (int x = 0; x < attributes.getLength(); ++x) {
                            String tmp = xpath.evaluate(".", attributes.item(x));
                            if (".pom".equals(tmp)) {
                                pomAvailable = true;
                                continue;
                            }
                            if (!".jar".equals(tmp)) continue;
                            jarAvailable = true;
                        }
                        String centralContentUrl = this.settings.getString("central.content.url");
                        String artifactUrl = null;
                        String pomUrl = null;
                        if (jarAvailable) {
                            artifactUrl = centralContentUrl + g.replace('.', '/') + '/' + a + '/' + v + '/' + a + '-' + v + ".jar";
                        }
                        if (pomAvailable) {
                            pomUrl = centralContentUrl + g.replace('.', '/') + '/' + a + '/' + v + '/' + a + '-' + v + ".pom";
                        }
                        result.add(new MavenArtifact(g, a, v, artifactUrl, pomUrl));
                    }
                }
            }
            catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
                throw new IOException(e.getMessage(), e);
            }
            if (missing) {
                if (this.cache != null) {
                    this.cache.put(sha1, result);
                }
                throw new FileNotFoundException("Artifact not found in Central");
            }
        } else {
            if (conn.getResponseCode() == 429) {
                String errorMessage = "Too many requests sent to MavenCentral; additional requests are being rejected.";
                throw new TooManyRequestsException("Too many requests sent to MavenCentral; additional requests are being rejected.");
            }
            String errorMessage = "Could not connect to MavenCentral (" + conn.getResponseCode() + "): " + conn.getResponseMessage();
            throw new IOException(errorMessage);
        }
        if (this.cache != null) {
            this.cache.put(sha1, result);
        }
        return result;
    }

    private boolean isInvalidURL(String url) {
        try {
            URL u = new URL(url);
            u.toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOGGER.trace("URL is invalid: {}", (Object)url);
            return true;
        }
        return false;
    }
}

