/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvd.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import org.owasp.dependencycheck.data.nvd.json.DefCpeMatch;
import org.owasp.dependencycheck.data.nvd.json.DefNode;

@ThreadSafe
public final class CpeMatchStreamCollector
implements Collector<DefNode, ArrayList<DefCpeMatch>, Stream<DefCpeMatch>> {
    private static final CpeMatchStreamCollector INSTANCE = new CpeMatchStreamCollector();

    public static CpeMatchStreamCollector getInstance() {
        return INSTANCE;
    }

    private CpeMatchStreamCollector() {
    }

    @Override
    public Supplier<ArrayList<DefCpeMatch>> supplier() {
        return ArrayList::new;
    }

    @Override
    public BiConsumer<ArrayList<DefCpeMatch>, DefNode> accumulator() {
        return (match, nodes) -> match.addAll(nodes.getCpeMatch());
    }

    @Override
    public BinaryOperator<ArrayList<DefCpeMatch>> combiner() {
        return (map, other) -> {
            map.addAll(other);
            return map;
        };
    }

    @Override
    public Function<ArrayList<DefCpeMatch>, Stream<DefCpeMatch>> finisher() {
        return Collection::stream;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return EnumSet.of(Collector.Characteristics.UNORDERED);
    }
}

