/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvd.ecosystem;

import org.owasp.dependencycheck.utils.Settings;

public final class Ecosystem {
    public static final String RUBY = "ruby";
    public static final String DOTNET = "dotnet";
    public static final String IOS = "ios";
    public static final String PHP = "php";
    public static final String GOLANG = "golang";
    public static final String JAVA = "java";
    public static final String NATIVE = "native";
    public static final String PYTHON = "python";
    public static final String JAVASCRIPT = "js";
    public static final String NODEJS = "nodejs";
    public static final String RUST = "rust";
    public static final String COLDFUSION = "coldfusion";
    public static final String PERL = "perl";
    public static final String ELIXIR = "exlixir";
    public static final String DART = "dart";
    private final Settings settings;
    private final int defaultQuerySize;

    public Ecosystem(Settings settings) {
        this.settings = settings;
        this.defaultQuerySize = settings.getInt("odc.ecosystem.maxquerylimit.default", 100);
    }

    public int getLuceneMaxQueryLimitFor(String ecosystem) {
        return this.settings.getInt("odc.ecosystem.maxquerylimit." + ecosystem, this.defaultQuerySize);
    }
}

