/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.update.nvd;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.time.Instant;
import org.apache.commons.io.FileUtils;
import org.owasp.dependencycheck.data.update.nvd.DownloadTask;
import org.owasp.dependencycheck.utils.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvdCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownloadTask.class);
    private final Settings settings;

    public NvdCache(Settings settings) {
        this.settings = settings;
    }

    public boolean notInCache(URL url, File file) {
        try {
            long validEpoch = Instant.now().toEpochMilli() - 14400000L;
            File tmp = new File(url.getPath());
            String filename = tmp.getName();
            File cache = new File(this.settings.getDataDirectory(), "nvdcache");
            if (!cache.isDirectory()) {
                return true;
            }
            File nvdFile = new File(cache, filename);
            if (nvdFile.isFile() && nvdFile.lastModified() > validEpoch) {
                LOGGER.debug("Copying {} from cache", (Object)url);
                FileUtils.copyFile((File)nvdFile, (File)file);
                return false;
            }
            return true;
        }
        catch (IOException ex) {
            LOGGER.debug("Error checking for nvd file in cache", (Throwable)ex);
            return true;
        }
    }

    public void storeInCache(URL url, File file) {
        if (file.isFile()) {
            try {
                File tmp = new File(url.getPath());
                String filename = tmp.getName();
                File cache = new File(this.settings.getDataDirectory(), "nvdcache");
                if (!cache.isDirectory() && !cache.mkdir()) {
                    return;
                }
                File nvdFile = new File(cache, filename);
                FileUtils.copyFile((File)file, (File)nvdFile);
                if (!nvdFile.setLastModified(Instant.now().toEpochMilli())) {
                    LOGGER.debug("Unable to set last modified date on {}", (Object)nvdFile);
                }
            }
            catch (IOException ex) {
                LOGGER.debug("Error storing nvd file in cache", (Throwable)ex);
            }
        }
    }

    public void evictFromCache(URL url) {
        try {
            File tmp = new File(url.getPath());
            String filename = tmp.getName();
            File cache = new File(this.settings.getDataDirectory(), "nvdcache");
            if (!cache.isDirectory()) {
                return;
            }
            LOGGER.error("Removing file from cache for {} as a corrupted download is detected", (Object)url);
            File nvdFile = new File(cache, filename);
            Files.delete(nvdFile.toPath());
        }
        catch (IOException ex) {
            LOGGER.warn("Error evicting corrupt nvd file from cache", (Throwable)ex);
        }
    }
}

