/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import java.util.List;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Dependency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnusedSuppressionRuleAnalyzer
extends AbstractAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnusedSuppressionRuleAnalyzer.class);
    private boolean reported = false;

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        if (!this.reported) {
            this.logUnusedRules(engine);
            this.reported = true;
        }
    }

    private void logUnusedRules(Engine engine) {
        if (engine.hasObject("suppression.rules")) {
            List rules = (List)engine.getObject("suppression.rules");
            rules.forEach(rule -> {
                if (!rule.isMatched() && !rule.isBase()) {
                    LOGGER.info("Suppression Rule had zero matches: {}", (Object)rule.toString());
                }
            });
        }
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.vulnerabilitysuppression.enabled";
    }

    @Override
    public String getName() {
        return "Unused Suppression Rule Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.FINAL;
    }

    @Override
    public boolean supportsParallelProcessing() {
        return false;
    }
}

