/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.analyzer;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import com.github.packageurl.PackageURLBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.AbstractFileTypeAnalyzer;
import org.owasp.dependencycheck.analyzer.AnalysisPhase;
import org.owasp.dependencycheck.analyzer.Experimental;
import org.owasp.dependencycheck.analyzer.JarAnalyzer;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.dependency.Confidence;
import org.owasp.dependencycheck.dependency.Dependency;
import org.owasp.dependencycheck.dependency.EvidenceType;
import org.owasp.dependencycheck.dependency.naming.GenericIdentifier;
import org.owasp.dependencycheck.dependency.naming.PurlIdentifier;
import org.owasp.dependencycheck.exception.InitializationException;
import org.owasp.dependencycheck.utils.FileFilterBuilder;
import org.owasp.dependencycheck.utils.UrlStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
@ThreadSafe
public class PythonPackageAnalyzer
extends AbstractFileTypeAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonPackageAnalyzer.class);
    public static final String DEPENDENCY_ECOSYSTEM = "python";
    private static final int REGEX_OPTIONS = 34;
    private static final String EXTENSIONS = "py";
    private static final Pattern MODULE_DOCSTRING = Pattern.compile("^(['\\\"]{3})(.*?)\\1", 34);
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\b(__)?version(__)? *= *(['\"]+)(\\d+\\.\\d+.*?)\\3", 34);
    private static final Pattern TITLE_PATTERN = PythonPackageAnalyzer.compileAssignPattern("title");
    private static final Pattern SUMMARY_PATTERN = PythonPackageAnalyzer.compileAssignPattern("summary");
    private static final Pattern URI_PATTERN = PythonPackageAnalyzer.compileAssignPattern("ur[il]");
    private static final Pattern HOMEPAGE_PATTERN = PythonPackageAnalyzer.compileAssignPattern("home_?page");
    private static final Pattern AUTHOR_PATTERN = PythonPackageAnalyzer.compileAssignPattern("author");
    private static final FileFilter INIT_PY_FILTER = new NameFileFilter("__init__.py");
    private static final FileFilter PY_FILTER = new SuffixFileFilter(".py");
    private static final FileFilter FILTER = FileFilterBuilder.newInstance().addExtensions("py").build();

    @Override
    public String getName() {
        return "Python Package Analyzer";
    }

    @Override
    public AnalysisPhase getAnalysisPhase() {
        return AnalysisPhase.INFORMATION_COLLECTION;
    }

    @Override
    protected String getAnalyzerEnabledSettingKey() {
        return "analyzer.python.package.enabled";
    }

    @Override
    protected FileFilter getFileFilter() {
        return FILTER;
    }

    @Override
    protected void prepareFileTypeAnalyzer(Engine engine) throws InitializationException {
    }

    private static Pattern compileAssignPattern(String name) {
        return Pattern.compile(String.format("\\b(__)?%s(__)?\\b *= *(['\"]+)(.*?)\\3", name), 34);
    }

    @Override
    protected void analyzeDependency(Dependency dependency, Engine engine) throws AnalysisException {
        dependency.setEcosystem(DEPENDENCY_ECOSYSTEM);
        File file = dependency.getActualFile();
        File parent = file.getParentFile();
        String parentName = parent.getName();
        if (INIT_PY_FILTER.accept(file)) {
            dependency.addEvidence(EvidenceType.PRODUCT, file.getName(), "PackageName", parentName, Confidence.HIGHEST);
            dependency.setName(parentName);
            File[] fileList = parent.listFiles(PY_FILTER);
            if (fileList != null) {
                for (File sourceFile : fileList) {
                    this.analyzeFileContents(dependency, sourceFile);
                }
            }
        } else {
            engine.removeDependency(dependency);
        }
    }

    private void analyzeFileContents(Dependency dependency, File file) throws AnalysisException {
        String contents;
        try {
            contents = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8).trim();
        }
        catch (IOException e) {
            throw new AnalysisException("Problem occurred while reading dependency file.", e);
        }
        if (!contents.isEmpty()) {
            String source = file.getName();
            this.gatherEvidence(dependency, EvidenceType.VERSION, VERSION_PATTERN, contents, source, "SourceVersion", Confidence.MEDIUM);
            this.addSummaryInfo(dependency, SUMMARY_PATTERN, 4, contents, source, "summary");
            if (INIT_PY_FILTER.accept(file)) {
                this.addSummaryInfo(dependency, MODULE_DOCSTRING, 2, contents, source, "docstring");
            }
            this.gatherEvidence(dependency, EvidenceType.PRODUCT, TITLE_PATTERN, contents, source, "SourceTitle", Confidence.LOW);
            this.gatherEvidence(dependency, EvidenceType.VENDOR, AUTHOR_PATTERN, contents, source, "SourceAuthor", Confidence.MEDIUM);
            this.gatherHomePageEvidence(dependency, EvidenceType.VENDOR, URI_PATTERN, source, "URL", contents);
            this.gatherHomePageEvidence(dependency, EvidenceType.VENDOR, HOMEPAGE_PATTERN, source, "HomePage", contents);
            try {
                PackageURLBuilder builder = PackageURLBuilder.aPackageURL().withType("pypi").withName(dependency.getName());
                if (dependency.getVersion() != null) {
                    builder.withVersion(dependency.getVersion());
                }
                PackageURL purl = builder.build();
                dependency.addSoftwareIdentifier(new PurlIdentifier(purl, Confidence.HIGHEST));
            }
            catch (MalformedPackageURLException ex) {
                LOGGER.debug("Unable to build package url for python", (Throwable)ex);
                GenericIdentifier id = dependency.getVersion() != null ? new GenericIdentifier("generic:" + dependency.getName() + "@" + dependency.getVersion(), Confidence.HIGHEST) : new GenericIdentifier("generic:" + dependency.getName(), Confidence.HIGHEST);
                dependency.addSoftwareIdentifier(id);
            }
        }
    }

    private void addSummaryInfo(Dependency dependency, Pattern pattern, int group, String contents, String source, String key) {
        Matcher matcher = pattern.matcher(contents);
        boolean found = matcher.find();
        if (found) {
            JarAnalyzer.addDescription(dependency, matcher.group(group), source, key);
        }
    }

    private void gatherHomePageEvidence(Dependency dependency, EvidenceType type, Pattern pattern, String source, String name, String contents) {
        String url;
        Matcher matcher = pattern.matcher(contents);
        if (matcher.find() && UrlStringUtils.isUrl(url = matcher.group(4))) {
            dependency.addEvidence(type, source, name, url, Confidence.MEDIUM);
        }
    }

    private void gatherEvidence(Dependency dependency, EvidenceType type, Pattern pattern, String contents, String source, String name, Confidence confidence) {
        Matcher matcher = pattern.matcher(contents);
        boolean found = matcher.find();
        if (found) {
            dependency.addEvidence(type, source, name, matcher.group(4), confidence);
            if (type == EvidenceType.VERSION) {
                dependency.setVersion(matcher.group(4));
                String dispName = String.format("%s:%s", dependency.getName(), dependency.getVersion());
                dependency.setDisplayFileName(dispName);
            }
        }
    }
}

