/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PyPACoreMetadataParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PyPACoreMetadataParser.class);
    private static final int SUPPORTED_MAJOR_UPPERBOUND = 2;
    private static final BigDecimal MAX_SUPPORTED_VERSION = BigDecimal.valueOf(22L, 1);

    private PyPACoreMetadataParser() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties getProperties(File file) throws AnalysisException {
        try (BufferedReader utf8Reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
            Properties properties = PyPACoreMetadataParser.getProperties(utf8Reader);
            return properties;
        }
        catch (IOException | IllegalArgumentException e) {
            throw new AnalysisException("Error parsing PyPA core-metadata file", e);
        }
    }

    public static Properties getProperties(BufferedReader utf8Reader) throws IOException {
        Properties result = new Properties();
        String line = utf8Reader.readLine();
        StringBuilder singleHeader = null;
        boolean inDescription = false;
        while (line != null && !line.isEmpty()) {
            if (inDescription && line.startsWith("       |")) {
                singleHeader.append('\n').append(line.substring(8));
            } else if (singleHeader != null && line.startsWith(" ")) {
                singleHeader.append(line.substring(1));
            } else {
                if (singleHeader != null) {
                    PyPACoreMetadataParser.parseAndAddHeader(result, singleHeader);
                }
                singleHeader = new StringBuilder(line);
                inDescription = line.startsWith("Description:");
            }
            line = utf8Reader.readLine();
        }
        if (singleHeader != null) {
            PyPACoreMetadataParser.parseAndAddHeader(result, singleHeader);
        }
        return result;
    }

    private static void parseAndAddHeader(Properties metadata, StringBuilder metadataHeader) {
        String[] keyValue = StringUtils.split((String)metadataHeader.toString(), (String)":", (int)2);
        if (keyValue.length != 2) {
            LOGGER.warn("Invalid mailheader format encountered in Wheel Metadata, not a \"key: value\" string");
            return;
        }
        String key = keyValue[0];
        String value = keyValue[1].trim();
        if ("Metadata-Version".equals(key)) {
            int majorVersion = Integer.parseInt(value.substring(0, value.indexOf(46)), 10);
            BigDecimal version = new BigDecimal(value);
            if (majorVersion > 2) {
                throw new IllegalArgumentException(String.format("Unsupported PyPA Wheel metadata. Metadata-Version is '%s', largest supported major is %d", value, 2));
            }
            if (version.compareTo(MAX_SUPPORTED_VERSION) > 0 && LOGGER.isWarnEnabled()) {
                LOGGER.warn(String.format("Wheel metadata Metadata-Version (%s) has a larger minor version than the highest known supported Metadata specification (%s) continuing with best effort", value, MAX_SUPPORTED_VERSION));
            }
        }
        metadata.setProperty(key, value);
    }
}

