/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging.util;

import org.owasp.security.logging.util.DefaultIntervalLoggerModel;
import org.owasp.security.logging.util.DefaultIntervalLoggerView;
import org.owasp.security.logging.util.IntervalLoggerController;
import org.owasp.security.logging.util.IntervalLoggerModel;
import org.owasp.security.logging.util.IntervalLoggerView;
import org.owasp.security.logging.util.IntervalProperty;

class DefaultIntervalLoggerController
implements IntervalLoggerController,
Runnable {
    private static final int INTERVAL_DEFAULT = 15000;
    private int interval = 15000;
    private boolean running = false;
    private IntervalLoggerView view = new DefaultIntervalLoggerView();
    private IntervalLoggerModel model = new DefaultIntervalLoggerModel();

    DefaultIntervalLoggerController() {
    }

    @Override
    public synchronized void start(int interval) {
        this.interval = interval;
        this.start();
    }

    @Override
    public synchronized void start() {
        if (!this.running) {
            new Thread(this).start();
            this.running = true;
        }
    }

    @Override
    public synchronized void stop() {
        this.running = false;
    }

    synchronized boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        while (this.running) {
            long interval_end = System.currentTimeMillis() + (long)this.interval;
            while (interval_end > System.currentTimeMillis()) {
                Thread.yield();
            }
            this.fireIntervalElapsed();
        }
        this.running = false;
    }

    @Override
    public synchronized void setStatusMessageView(IntervalLoggerView view) {
        this.view = view;
    }

    @Override
    public synchronized void setStatusMessageModel(IntervalLoggerModel model) {
        this.model = model;
    }

    private void fireIntervalElapsed() {
        IntervalProperty[] properties = this.model.getProperties();
        this.model.refresh();
        String msg = this.view.formatStatusMessage(properties);
        this.view.logMessage(msg);
    }
}

