/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging.util;

import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import org.owasp.security.logging.util.OutputStreamRedirector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityUtil {
    private static final Logger logger = LoggerFactory.getLogger(SecurityUtil.class);
    private static Logger sysOutLogger = LoggerFactory.getLogger(SecurityUtil.class);
    private static Logger sysErrLogger = LoggerFactory.getLogger(SecurityUtil.class);
    public static final PrintStream sysout = System.out;
    public static final PrintStream syserr = System.err;

    private SecurityUtil() {
    }

    public static void bindSystemStreamsToSLF4J() {
        System.setOut(new PrintStream(new OutputStreamRedirector(sysOutLogger, false), true));
        System.setErr(new PrintStream(new OutputStreamRedirector(sysErrLogger, true), true));
    }

    public static void bindSystemStreamsToSLF4J(Logger sysOutLogger, Logger sysErrLogger) {
        SecurityUtil.sysOutLogger = sysOutLogger;
        SecurityUtil.sysErrLogger = sysErrLogger;
        SecurityUtil.bindSystemStreamsToSLF4J();
    }

    public static void unbindSystemStreams() {
        System.setOut(sysout);
        System.setErr(syserr);
    }

    public static void logCommandLineArguments(String[] args) {
        if (args == null || args.length < 1) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            SecurityUtil.logMessage("Cmd line arg[" + i + "]=" + args[i]);
        }
    }

    public static void logShellEnvironmentVariables() {
        Map<String, String> env = System.getenv();
        for (String key : env.keySet()) {
            String value = env.get(key);
            SecurityUtil.logMessage("Env, " + key + "=" + value.trim());
        }
    }

    public static void logJavaSystemProperties() {
        Properties properties = System.getProperties();
        for (Object key : properties.keySet()) {
            Object value = properties.get(key);
            SecurityUtil.logMessage("SysProp, " + key + "=" + value.toString().trim());
        }
    }

    public static void logMessage(String message) {
        logger.info(message);
    }
}

