/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client.rest;

import org.pac4j.cas.client.rest.AbstractCasRestClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.credentials.authenticator.CasRestAuthenticator;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.FormExtractor;
import org.pac4j.core.util.CommonHelper;

public class CasRestFormClient
extends AbstractCasRestClient {
    private String usernameParameter = "username";
    private String passwordParameter = "password";

    public CasRestFormClient() {
    }

    public CasRestFormClient(CasConfiguration configuration, String usernameParameter, String passwordParameter) {
        this.configuration = configuration;
        this.usernameParameter = usernameParameter;
        this.passwordParameter = passwordParameter;
    }

    protected void clientInit(WebContext context) {
        CommonHelper.assertNotBlank((String)"usernameParameter", (String)this.usernameParameter);
        CommonHelper.assertNotBlank((String)"passwordParameter", (String)this.passwordParameter);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        this.configuration.init(context);
        this.defaultCredentialsExtractor((CredentialsExtractor)new FormExtractor(this.usernameParameter, this.passwordParameter, this.getName()));
        this.defaultAuthenticator(new CasRestAuthenticator(this.configuration));
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public String toString() {
        return CommonHelper.toString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "usernameParameter", this.usernameParameter, "passwordParameter", this.passwordParameter, "configuration", this.configuration, "extractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator()});
    }
}

