/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client.direct;

import java.util.Optional;
import org.jasig.cas.client.util.CommonUtils;
import org.pac4j.cas.authorization.DefaultCasAuthorizationGenerator;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.credentials.authenticator.CasAuthenticator;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.ParameterExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.RedirectionActionHelper;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.util.CommonHelper;

public class DirectCasClient
extends DirectClient<TokenCredentials> {
    private CasConfiguration configuration;
    private UrlResolver urlResolver = new DefaultUrlResolver();
    private CallbackUrlResolver callbackUrlResolver = new NoParameterCallbackUrlResolver();

    public DirectCasClient() {
    }

    public DirectCasClient(CasConfiguration casConfiguration) {
        this.configuration = casConfiguration;
    }

    protected void clientInit() {
        CommonHelper.assertNotNull((String)"urlResolver", (Object)this.urlResolver);
        CommonHelper.assertNotNull((String)"callbackUrlResolver", (Object)this.callbackUrlResolver);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        CommonHelper.assertTrue((!this.configuration.isGateway() ? 1 : 0) != 0, (String)"the DirectCasClient can not support gateway to avoid infinite loops");
        this.defaultCredentialsExtractor((CredentialsExtractor)new ParameterExtractor("ticket", true, false));
        super.defaultAuthenticator((Authenticator)new CasAuthenticator(this.configuration, this.getName(), this.urlResolver, this.callbackUrlResolver, "fake"));
        this.addAuthorizationGenerator(new DefaultCasAuthorizationGenerator());
    }

    protected Optional<TokenCredentials> retrieveCredentials(WebContext context) {
        this.init();
        try {
            String callbackUrl = this.callbackUrlResolver.compute(this.urlResolver, context.getFullRequestURL(), this.getName(), context);
            String loginUrl = this.configuration.computeFinalLoginUrl(context);
            Optional credentials = this.getCredentialsExtractor().extract(context);
            if (!credentials.isPresent()) {
                String redirectionUrl = CommonUtils.constructRedirectUrl((String)loginUrl, (String)"service", (String)callbackUrl, (boolean)this.configuration.isRenew(), (boolean)false);
                this.logger.debug("redirectionUrl: {}", (Object)redirectionUrl);
                throw RedirectionActionHelper.buildRedirectUrlAction((WebContext)context, (String)redirectionUrl);
            }
            callbackUrl = CommonHelper.substringBefore((String)callbackUrl, (String)"?ticket=");
            callbackUrl = CommonHelper.substringBefore((String)callbackUrl, (String)"&ticket=");
            CasAuthenticator casAuthenticator = new CasAuthenticator(this.configuration, this.getName(), this.urlResolver, this.callbackUrlResolver, callbackUrl);
            casAuthenticator.init();
            casAuthenticator.validate((TokenCredentials)credentials.get(), context);
            return credentials;
        }
        catch (CredentialsException e) {
            this.logger.error("Failed to retrieve or validate CAS credentials", (Throwable)e);
            return Optional.empty();
        }
    }

    protected void defaultAuthenticator(Authenticator authenticator) {
        throw new TechnicalException("You can not set an Authenticator for the DirectCasClient at startup. A new CasAuthenticator is automatically created for each request");
    }

    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
    }

    public UrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    public void setUrlResolver(UrlResolver urlResolver) {
        this.urlResolver = urlResolver;
    }

    public CallbackUrlResolver getCallbackUrlResolver() {
        return this.callbackUrlResolver;
    }

    public void setCallbackUrlResolver(CallbackUrlResolver callbackUrlResolver) {
        this.callbackUrlResolver = callbackUrlResolver;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"name", this.getName(), "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "authorizationGenerators", this.getAuthorizationGenerators(), "configuration", this.configuration, "urlResolver", this.urlResolver, "callbackUrlResolver", this.callbackUrlResolver});
    }
}

