/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.redirect;

import java.util.Optional;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.util.CommonUtils;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.RedirectionAction;
import org.pac4j.core.exception.http.RedirectionActionHelper;
import org.pac4j.core.redirect.RedirectionActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasRedirectionActionBuilder
implements RedirectionActionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(CasRedirectionActionBuilder.class);
    protected CasConfiguration configuration;
    protected CasClient client;

    public CasRedirectionActionBuilder(CasConfiguration configuration, CasClient client) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        CommonHelper.assertNotNull((String)"client", (Object)((Object)client));
        this.configuration = configuration;
        this.client = client;
    }

    public Optional<RedirectionAction> redirect(WebContext context) {
        String computeLoginUrl = this.configuration.computeFinalLoginUrl(context);
        String method = this.configuration.getMethod();
        if (method != null) {
            computeLoginUrl = CommonHelper.addParameter((String)computeLoginUrl, (String)"method", (String)method);
        }
        String computedCallbackUrl = this.client.computeFinalCallbackUrl(context);
        String redirectionUrl = CommonUtils.constructRedirectUrl((String)computeLoginUrl, (String)this.getServiceParameter(), (String)computedCallbackUrl, (boolean)this.configuration.isRenew(), (boolean)this.configuration.isGateway());
        logger.debug("redirectionUrl: {}", (Object)redirectionUrl);
        return Optional.of(RedirectionActionHelper.buildRedirectUrlAction((WebContext)context, (String)redirectionUrl));
    }

    private String getServiceParameter() {
        if (this.configuration.getProtocol() == CasProtocol.SAML) {
            return Protocol.SAML11.getServiceParameterName();
        }
        return "service";
    }
}

