/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.authorization.authorizer.csrf;

import java.util.List;
import org.pac4j.core.authorization.authorizer.Authorizer;
import org.pac4j.core.context.ContextHelper;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.profile.CommonProfile;

public class CsrfAuthorizer
implements Authorizer<CommonProfile> {
    private String parameterName = "pac4jCsrfToken";
    private String headerName = "pac4jCsrfToken";
    private boolean onlyCheckPostRequest = true;

    public CsrfAuthorizer() {
    }

    public CsrfAuthorizer(String parameterName, String headerName) {
        this.parameterName = parameterName;
        this.headerName = headerName;
    }

    public CsrfAuthorizer(String parameterName, String headerName, boolean onlyCheckPostRequest) {
        this(parameterName, headerName);
        this.onlyCheckPostRequest = onlyCheckPostRequest;
    }

    @Override
    public boolean isAuthorized(WebContext context, List<CommonProfile> profiles) throws HttpAction {
        boolean checkRequest;
        boolean bl = checkRequest = !this.onlyCheckPostRequest || ContextHelper.isPost(context);
        if (checkRequest) {
            String parameterToken = context.getRequestParameter(this.parameterName);
            String headerToken = context.getRequestHeader(this.headerName);
            String sessionToken = (String)context.getSessionAttribute("pac4jCsrfToken");
            return sessionToken != null && (sessionToken.equals(parameterToken) || sessionToken.equals(headerToken));
        }
        return true;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public boolean isOnlyCheckPostRequest() {
        return this.onlyCheckPostRequest;
    }

    public void setOnlyCheckPostRequest(boolean onlyCheckPostRequest) {
        this.onlyCheckPostRequest = onlyCheckPostRequest;
    }
}

