/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.client;

import org.pac4j.core.client.BaseClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.exception.HttpAction;
import org.pac4j.core.http.AjaxRequestResolver;
import org.pac4j.core.http.DefaultAjaxRequestResolver;
import org.pac4j.core.http.DefaultUrlResolver;
import org.pac4j.core.http.UrlResolver;
import org.pac4j.core.logout.LogoutActionBuilder;
import org.pac4j.core.logout.NoLogoutActionBuilder;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.redirect.RedirectActionBuilder;
import org.pac4j.core.util.CommonHelper;

public abstract class IndirectClient<C extends Credentials, U extends CommonProfile>
extends BaseClient<C, U> {
    public static final String ATTEMPTED_AUTHENTICATION_SUFFIX = "$attemptedAuthentication";
    protected String callbackUrl;
    private boolean includeClientNameInCallbackUrl = true;
    protected UrlResolver urlResolver = new DefaultUrlResolver();
    private AjaxRequestResolver ajaxRequestResolver = new DefaultAjaxRequestResolver();
    private RedirectActionBuilder redirectActionBuilder;
    private LogoutActionBuilder<U> logoutActionBuilder = NoLogoutActionBuilder.INSTANCE;

    @Override
    protected final void internalInit(WebContext context) {
        CommonHelper.assertNotBlank("callbackUrl", this.callbackUrl, "set it up either on this IndirectClient or the global Config");
        CommonHelper.assertNotNull("urlResolver", this.urlResolver);
        CommonHelper.assertNotNull("ajaxRequestResolver", this.ajaxRequestResolver);
        this.clientInit(context);
        CommonHelper.assertNotNull("redirectActionBuilder", this.redirectActionBuilder);
        CommonHelper.assertNotNull("credentialsExtractor", this.getCredentialsExtractor());
        CommonHelper.assertNotNull("authenticator", this.getAuthenticator());
        CommonHelper.assertNotNull("profileCreator", this.getProfileCreator());
        CommonHelper.assertNotNull("logoutActionBuilder", this.logoutActionBuilder);
    }

    protected abstract void clientInit(WebContext var1);

    @Override
    public final HttpAction redirect(WebContext context) throws HttpAction {
        RedirectAction action = this.getRedirectAction(context);
        return action.perform(context);
    }

    public RedirectAction getRedirectAction(WebContext context) throws HttpAction {
        this.init(context);
        if (this.ajaxRequestResolver.isAjax(context)) {
            this.logger.info("AJAX request detected -> returning 401");
            RedirectAction action = this.redirectActionBuilder.redirect(context);
            this.cleanRequestedUrl(context);
            throw HttpAction.unauthorized("AJAX request -> 401", context, null, action.getLocation());
        }
        String attemptedAuth = (String)context.getSessionAttribute(this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX);
        if (CommonHelper.isNotBlank(attemptedAuth)) {
            this.cleanAttemptedAuthentication(context);
            this.cleanRequestedUrl(context);
            throw HttpAction.unauthorized("authentication already tried -> forbidden", context, null, null);
        }
        return this.redirectActionBuilder.redirect(context);
    }

    private void cleanRequestedUrl(WebContext context) {
        context.setSessionAttribute("pac4jRequestedUrl", "");
    }

    private void cleanAttemptedAuthentication(WebContext context) {
        context.setSessionAttribute(this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX, "");
    }

    @Override
    public final C getCredentials(WebContext context) throws HttpAction {
        this.init(context);
        Object credentials = this.retrieveCredentials(context);
        if (credentials == null) {
            context.setSessionAttribute(this.getName() + ATTEMPTED_AUTHENTICATION_SUFFIX, "true");
        } else {
            this.cleanAttemptedAuthentication(context);
        }
        return credentials;
    }

    @Override
    public final RedirectAction getLogoutAction(WebContext context, U currentProfile, String targetUrl) {
        this.init(context);
        return this.logoutActionBuilder.getLogoutAction(context, currentProfile, targetUrl);
    }

    public String computeFinalCallbackUrl(WebContext context) {
        return this.urlResolver.compute(this.callbackUrl, context);
    }

    public boolean isIncludeClientNameInCallbackUrl() {
        return this.includeClientNameInCallbackUrl;
    }

    public void setIncludeClientNameInCallbackUrl(boolean includeClientNameInCallbackUrl) {
        this.includeClientNameInCallbackUrl = includeClientNameInCallbackUrl;
    }

    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    @Deprecated
    public UrlResolver getCallbackUrlResolver() {
        return this.getUrlResolver();
    }

    @Deprecated
    public void setCallbackUrlResolver(UrlResolver callbackUrlResolver) {
        this.setUrlResolver(callbackUrlResolver);
    }

    public UrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    public void setUrlResolver(UrlResolver urlResolver) {
        this.urlResolver = urlResolver;
    }

    public AjaxRequestResolver getAjaxRequestResolver() {
        return this.ajaxRequestResolver;
    }

    public void setAjaxRequestResolver(AjaxRequestResolver ajaxRequestResolver) {
        this.ajaxRequestResolver = ajaxRequestResolver;
    }

    public RedirectActionBuilder getRedirectActionBuilder() {
        return this.redirectActionBuilder;
    }

    protected void defaultRedirectActionBuilder(RedirectActionBuilder redirectActionBuilder) {
        if (this.redirectActionBuilder == null) {
            this.redirectActionBuilder = redirectActionBuilder;
        }
    }

    public LogoutActionBuilder<U> getLogoutActionBuilder() {
        return this.logoutActionBuilder;
    }

    protected void defaultLogoutActionBuilder(LogoutActionBuilder<U> logoutActionBuilder) {
        if (this.logoutActionBuilder == null || this.logoutActionBuilder == NoLogoutActionBuilder.INSTANCE) {
            this.logoutActionBuilder = logoutActionBuilder;
        }
    }

    public void setRedirectActionBuilder(RedirectActionBuilder redirectActionBuilder) {
        this.redirectActionBuilder = redirectActionBuilder;
    }

    public void setLogoutActionBuilder(LogoutActionBuilder<U> logoutActionBuilder) {
        this.logoutActionBuilder = logoutActionBuilder;
    }

    @Override
    public String toString() {
        return CommonHelper.toString(this.getClass(), "name", this.getName(), "callbackUrl", this.callbackUrl, "urlResolver", this.urlResolver, "ajaxRequestResolver", this.ajaxRequestResolver, "includeClientNameInCallbackUrl", this.includeClientNameInCallbackUrl, "redirectActionBuilder", this.redirectActionBuilder, "credentialsExtractor", this.getCredentialsExtractor(), "authenticator", this.getAuthenticator(), "profileCreator", this.getProfileCreator(), "logoutActionBuilder", this.logoutActionBuilder, "authorizationGenerators", this.getAuthorizationGenerators());
    }
}

