/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.gae.client;

import com.google.appengine.api.users.User;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import java.util.Optional;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.definition.CommonProfileDefinition;
import org.pac4j.core.profile.definition.ProfileDefinition;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.gae.credentials.GaeUserCredentials;
import org.pac4j.gae.profile.GaeUserServiceProfile;

public class GaeUserServiceClient
extends IndirectClient {
    private static final ProfileDefinition PROFILE_DEFINITION = new CommonProfileDefinition(x -> new GaeUserServiceProfile());
    protected UserService service;
    protected String authDomain = null;

    protected void internalInit(boolean forceReinit) {
        this.service = UserServiceFactory.getUserService();
        CommonHelper.assertNotNull((String)"service", (Object)this.service);
        this.defaultRedirectionActionBuilder((ctx, session) -> {
            String destinationUrl = this.computeFinalCallbackUrl(ctx);
            String loginUrl = this.authDomain == null ? this.service.createLoginURL(destinationUrl) : this.service.createLoginURL(destinationUrl, this.authDomain);
            return Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)ctx, (String)loginUrl));
        });
        this.defaultCredentialsExtractor((ctx, session) -> {
            GaeUserCredentials credentials = new GaeUserCredentials();
            credentials.setUser(this.service.getCurrentUser());
            return Optional.of(credentials);
        });
        this.defaultAuthenticator((credentials, ctx, session) -> {
            User user = ((GaeUserCredentials)credentials).getUser();
            if (user != null) {
                GaeUserServiceProfile profile = (GaeUserServiceProfile)PROFILE_DEFINITION.newProfile(new Object[0]);
                profile.setId(user.getEmail());
                PROFILE_DEFINITION.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, "email", (Object)user.getEmail());
                PROFILE_DEFINITION.convertAndAdd((UserProfile)profile, AttributeLocation.PROFILE_ATTRIBUTE, "display_name", (Object)user.getNickname());
                if (this.service.isUserAdmin()) {
                    profile.addRole("GLOBAL_ADMIN");
                }
                credentials.setUserProfile((UserProfile)profile);
            }
        });
    }

    public void setAuthDomain(String authDomain) {
        this.authDomain = authDomain;
    }

    public String getAuthDomain() {
        return this.authDomain;
    }
}

