/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.builder.api;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;
import java.util.Map;

public final class WordPressApi20
extends DefaultApi20 {
    private static final String BASE_URL = "https://public-api.wordpress.com/oauth2/";
    private static final String AUTHORIZE_URL = "https://public-api.wordpress.com/oauth2/authorize?client_id=%s&redirect_uri=%s&response_type=code";

    public String getAccessTokenEndpoint() {
        return "https://public-api.wordpress.com/oauth2/token";
    }

    public String getAuthorizationUrl(OAuthConfig config, Map<String, String> additionalParams) {
        Preconditions.checkValidUrl((String)config.getCallback(), (String)"Must provide a valid url as callback. WordPress does not support OOB");
        return String.format(AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback()));
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    protected String getAuthorizationBaseUrl() {
        return "https://public-api.wordpress.com/oauth2/authorize";
    }
}

