/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import net.shibboleth.utilities.java.support.net.BasicURLComparator;
import net.shibboleth.utilities.java.support.net.URIComparator;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.criterion.ProtocolCriterion;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.opensaml.xmlsec.encryption.support.DecryptionException;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.crypto.SAML2SignatureTrustEngineProvider;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.sso.SAML2ResponseValidator;
import org.pac4j.saml.storage.SAMLMessageStorage;
import org.pac4j.saml.util.UriUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2LogoutResponseValidator
implements SAML2ResponseValidator {
    private static final Logger logger = LoggerFactory.getLogger(SAML2LogoutResponseValidator.class);
    private int acceptedSkew = 120;
    private final SAML2SignatureTrustEngineProvider signatureTrustEngineProvider;
    private final URIComparator uriComparator;

    public SAML2LogoutResponseValidator(SAML2SignatureTrustEngineProvider engine) {
        this(engine, (URIComparator)new BasicURLComparator());
    }

    public SAML2LogoutResponseValidator(SAML2SignatureTrustEngineProvider engine, URIComparator uriComparator) {
        this.signatureTrustEngineProvider = engine;
        this.uriComparator = uriComparator;
    }

    @Override
    public Credentials validate(SAML2MessageContext context) {
        SAMLObject message = (SAMLObject)context.getMessage();
        if (!(message instanceof Response)) {
            throw new SAMLException("Response instance is an unsupported type");
        }
        Response response = (Response)message;
        SignatureTrustEngine engine = this.signatureTrustEngineProvider.build();
        this.validateSamlProtocolResponse(response, context, engine);
        return null;
    }

    protected final void validateSamlProtocolResponse(Response response, SAML2MessageContext context, SignatureTrustEngine engine) {
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(response.getStatus().getStatusCode().getValue())) {
            String status = response.getStatus().getStatusCode().getValue();
            if (response.getStatus().getStatusMessage() != null) {
                status = status + " / " + response.getStatus().getStatusMessage().getMessage();
            }
            throw new SAMLException("Logout response is not success ; actual " + status);
        }
        if (response.getSignature() != null) {
            String entityId = context.getSAMLPeerEntityContext().getEntityId();
            this.validateSignature(response.getSignature(), entityId, engine);
            context.getSAMLPeerEntityContext().setAuthenticated(true);
        }
        if (!this.isIssueInstantValid(response.getIssueInstant())) {
            throw new SAMLException("Response issue instant is too old or in the future");
        }
        SAMLMessageStorage messageStorage = context.getSAMLMessageStorage();
        if (messageStorage != null && response.getInResponseTo() != null) {
            XMLObject xmlObject = messageStorage.retrieveMessage(response.getInResponseTo());
            if (xmlObject == null) {
                throw new SAMLException("InResponseToField of the Response doesn't correspond to sent message " + response.getInResponseTo());
            }
            if (!(xmlObject instanceof LogoutRequest)) {
                throw new SAMLException("Sent request was of different type than the expected LogoutRequest " + response.getInResponseTo());
            }
        }
        this.verifyEndpoint(context.getSAMLEndpointContext().getEndpoint(), response.getDestination());
        if (response.getIssuer() != null) {
            this.validateIssuer(response.getIssuer(), context);
        }
    }

    protected final void verifyEndpoint(Endpoint endpoint, String destination) {
        try {
            if (destination != null && !this.uriComparator.compare(destination, endpoint.getLocation()) && !this.uriComparator.compare(destination, endpoint.getResponseLocation())) {
                throw new SAMLException("Intended destination " + destination + " doesn't match any of the endpoint URLs on endpoint " + endpoint.getLocation());
            }
        }
        catch (Exception e) {
            throw new SAMLException(e);
        }
    }

    protected final void validateIssuer(Issuer issuer, SAML2MessageContext context) {
        if (issuer.getFormat() != null && !issuer.getFormat().equals("urn:oasis:names:tc:SAML:2.0:nameid-format:entity")) {
            throw new SAMLException("Issuer type is not entity but " + issuer.getFormat());
        }
        String entityId = context.getSAMLPeerEntityContext().getEntityId();
        if (entityId == null || !entityId.equals(issuer.getValue())) {
            throw new SAMLException("Issuer " + issuer.getValue() + " does not match idp entityId " + entityId);
        }
    }

    protected final NameID decryptEncryptedId(EncryptedID encryptedId, Decrypter decrypter) throws SAMLException {
        if (encryptedId == null) {
            return null;
        }
        if (decrypter == null) {
            logger.warn("Encrypted attributes returned, but no keystore was provided.");
            return null;
        }
        try {
            NameID decryptedId = (NameID)decrypter.decrypt(encryptedId);
            return decryptedId;
        }
        catch (DecryptionException e) {
            throw new SAMLException("Decryption of an EncryptedID failed.", e);
        }
    }

    protected final boolean isValidBearerSubjectConfirmationData(SubjectConfirmationData data, SAML2MessageContext context) {
        if (data == null) {
            logger.debug("SubjectConfirmationData cannot be null for Bearer confirmation");
            return false;
        }
        if (data.getNotBefore() != null) {
            logger.debug("SubjectConfirmationData notBefore must be null for Bearer confirmation");
            return false;
        }
        if (data.getNotOnOrAfter() == null) {
            logger.debug("SubjectConfirmationData notOnOrAfter cannot be null for Bearer confirmation");
            return false;
        }
        if (data.getNotOnOrAfter().plusSeconds(this.acceptedSkew).isBeforeNow()) {
            logger.debug("SubjectConfirmationData notOnOrAfter is too old");
            return false;
        }
        try {
            URI appEndpointUri;
            if (data.getRecipient() == null) {
                logger.debug("SubjectConfirmationData recipient cannot be null for Bearer confirmation");
                return false;
            }
            Endpoint endpoint = context.getSAMLEndpointContext().getEndpoint();
            if (endpoint == null) {
                logger.warn("No endpoint was found in the SAML endpoint context");
                return false;
            }
            URI recipientUri = new URI(data.getRecipient());
            if (!UriUtils.urisEqualAfterPortNormalization(recipientUri, appEndpointUri = new URI(endpoint.getLocation()))) {
                logger.debug("SubjectConfirmationData recipient {} does not match SP assertion consumer URL, found. SP ACS URL from context: {}", (Object)recipientUri, (Object)appEndpointUri);
                return false;
            }
        }
        catch (URISyntaxException use) {
            logger.error("Unable to check SubjectConfirmationData recipient, a URI has invalid syntax.", (Throwable)use);
            return false;
        }
        return true;
    }

    protected final void validateAssertionConditions(Conditions conditions, SAML2MessageContext context) {
        if (conditions == null) {
            throw new SAMLException("Assertion conditions cannot be null");
        }
        if (conditions.getNotBefore() != null && conditions.getNotBefore().minusSeconds(this.acceptedSkew).isAfterNow()) {
            throw new SAMLException("Assertion condition notBefore is not valid");
        }
        if (conditions.getNotOnOrAfter() != null && conditions.getNotOnOrAfter().plusSeconds(this.acceptedSkew).isBeforeNow()) {
            throw new SAMLException("Assertion condition notOnOrAfter is not valid");
        }
        String entityId = context.getSAMLSelfEntityContext().getEntityId();
        this.validateAudienceRestrictions(conditions.getAudienceRestrictions(), entityId);
    }

    protected final void validateAudienceRestrictions(List<AudienceRestriction> audienceRestrictions, String spEntityId) {
        if (audienceRestrictions == null || audienceRestrictions.isEmpty()) {
            throw new SAMLException("Audience restrictions cannot be null or empty");
        }
        HashSet<String> audienceUris = new HashSet<String>();
        for (AudienceRestriction audienceRestriction : audienceRestrictions) {
            if (audienceRestriction.getAudiences() == null) continue;
            for (Audience audience : audienceRestriction.getAudiences()) {
                audienceUris.add(audience.getAudienceURI());
            }
        }
        if (!audienceUris.contains(spEntityId)) {
            throw new SAMLException("Assertion audience " + audienceUris + " does not match SP configuration " + spEntityId);
        }
    }

    protected final void validateAssertionSignature(Signature signature, SAML2MessageContext context, SignatureTrustEngine engine) {
        SAMLPeerEntityContext peerContext = context.getSAMLPeerEntityContext();
        if (signature != null) {
            String entityId = peerContext.getEntityId();
            this.validateSignature(signature, entityId, engine);
        } else if (!peerContext.isAuthenticated()) {
            throw new SAMLException("Assertion or response must be signed");
        }
    }

    protected final void validateSignature(Signature signature, String idpEntityId, SignatureTrustEngine trustEngine) {
        boolean valid;
        SAMLSignatureProfileValidator validator = new SAMLSignatureProfileValidator();
        try {
            validator.validate(signature);
        }
        catch (SignatureException e) {
            throw new SAMLException("SAMLSignatureProfileValidator failed to validate signature", e);
        }
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new UsageCriterion(UsageType.SIGNING));
        criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        criteriaSet.add((Object)new ProtocolCriterion("urn:oasis:names:tc:SAML:2.0:protocol"));
        criteriaSet.add((Object)new EntityIdCriterion(idpEntityId));
        try {
            valid = trustEngine.validate((Object)signature, criteriaSet);
        }
        catch (SecurityException e) {
            throw new SAMLException("An error occurred during signature validation", e);
        }
        if (!valid) {
            throw new SAMLException("Signature is not trusted");
        }
    }

    private boolean isDateValid(DateTime issueInstant, int interval) {
        boolean isDateValid;
        DateTime before = DateTime.now().plusSeconds(this.acceptedSkew);
        DateTime after = DateTime.now().minusSeconds(this.acceptedSkew + interval);
        boolean bl = isDateValid = issueInstant.isBefore((ReadableInstant)before) && issueInstant.isAfter((ReadableInstant)after);
        if (!isDateValid) {
            logger.trace("interval={},before={},after={},issueInstant={}", new Object[]{interval, before.toDateTime(issueInstant.getZone()), after.toDateTime(issueInstant.getZone()), issueInstant});
        }
        return isDateValid;
    }

    private boolean isIssueInstantValid(DateTime issueInstant) {
        return this.isDateValid(issueInstant, 0);
    }

    @Override
    public final void setAcceptedSkew(int acceptedSkew) {
        this.acceptedSkew = acceptedSkew;
    }

    @Override
    public final void setMaximumAuthenticationLifetime(int maximumAuthenticationLifetime) {
    }
}

