/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.spring;

import org.pf4j.ExtensionFactory;
import org.pf4j.Plugin;
import org.pf4j.PluginManager;
import org.pf4j.PluginWrapper;
import org.pf4j.spring.SpringPlugin;
import org.pf4j.spring.SpringPluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SpringExtensionFactory
implements ExtensionFactory {
    private static final Logger log = LoggerFactory.getLogger(SpringExtensionFactory.class);
    private PluginManager pluginManager;
    private boolean autowire;

    public SpringExtensionFactory(PluginManager pluginManager) {
        this(pluginManager, true);
    }

    public SpringExtensionFactory(PluginManager pluginManager, boolean autowire) {
        this.pluginManager = pluginManager;
        this.autowire = autowire;
    }

    public <T> T create(Class<T> extensionClass) {
        PluginWrapper pluginWrapper;
        T extension = this.createWithoutSpring(extensionClass);
        if (this.autowire && extension != null && (pluginWrapper = this.pluginManager.whichPlugin(extensionClass)) != null) {
            Plugin plugin = pluginWrapper.getPlugin();
            if (plugin instanceof SpringPlugin) {
                ApplicationContext pluginContext = ((SpringPlugin)plugin).getApplicationContext();
                pluginContext.getAutowireCapableBeanFactory().autowireBean(extension);
            } else if (this.pluginManager instanceof SpringPluginManager) {
                SpringPluginManager springPluginManager = (SpringPluginManager)this.pluginManager;
                ApplicationContext pluginContext = springPluginManager.getApplicationContext();
                pluginContext.getAutowireCapableBeanFactory().autowireBean(extension);
            }
        }
        return extension;
    }

    protected <T> T createWithoutSpring(Class<?> extensionClass) {
        try {
            return (T)extensionClass.newInstance();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

