/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.core.model.context.ResponseType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.saml.SAMLConditionsParser;
import org.picketlink.identity.federation.core.parsers.saml.SAMLSubjectParser;
import org.picketlink.identity.federation.core.parsers.util.SAMLParserUtil;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedAssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.saml.v2.profiles.xacml.assertion.XACMLAuthzDecisionStatementType;
import org.w3c.dom.Element;

public class SAMLAssertionParser
implements ParserNamespaceSupport {
    private final String ASSERTION = JBossSAMLConstants.ASSERTION.get();

    public AssertionType fromElement(Element element) throws ConfigurationException, ProcessingException, ParsingException {
        XMLEventReader xmlEventReader = StaxParserUtil.getXMLEventReader(DocumentUtil.getNodeAsStream(element));
        return (AssertionType)this.parse(xmlEventReader);
    }

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
        String startElementName = StaxParserUtil.getStartElementName(startElement);
        if (startElementName.equals(JBossSAMLConstants.ENCRYPTED_ASSERTION.get())) {
            Element domElement = StaxParserUtil.getDOMElement(xmlEventReader);
            EncryptedAssertionType encryptedAssertion = new EncryptedAssertionType();
            encryptedAssertion.setEncryptedElement(domElement);
            return encryptedAssertion;
        }
        startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, this.ASSERTION);
        AssertionType assertion = this.parseBaseAttributes(startElement);
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                xmlEvent = StaxParserUtil.getNextEvent(xmlEventReader);
                EndElement endElement = (EndElement)xmlEvent;
                String endElementTag = StaxParserUtil.getEndElementName(endElement);
                if (endElementTag.equals(JBossSAMLConstants.ASSERTION.get())) break;
                throw new RuntimeException("PL00061: Parser: Unknown End Element:" + endElementTag);
            }
            StartElement peekedElement = null;
            peekedElement = xmlEvent instanceof StartElement ? (StartElement)xmlEvent : StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (peekedElement == null) break;
            String tag = StaxParserUtil.getStartElementName(peekedElement);
            if (tag.equals(JBossSAMLConstants.SIGNATURE.get())) {
                assertion.setSignature(StaxParserUtil.getDOMElement(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.ISSUER.get().equalsIgnoreCase(tag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                String issuerValue = StaxParserUtil.getElementText(xmlEventReader);
                NameIDType issuer = new NameIDType();
                issuer.setValue(issuerValue);
                assertion.setIssuer(issuer);
                continue;
            }
            if (JBossSAMLConstants.SUBJECT.get().equalsIgnoreCase(tag)) {
                SAMLSubjectParser subjectParser = new SAMLSubjectParser();
                assertion.setSubject((SubjectType)subjectParser.parse(xmlEventReader));
                continue;
            }
            if (JBossSAMLConstants.CONDITIONS.get().equalsIgnoreCase(tag)) {
                SAMLConditionsParser conditionsParser = new SAMLConditionsParser();
                ConditionsType conditions = (ConditionsType)conditionsParser.parse(xmlEventReader);
                assertion.setConditions(conditions);
                continue;
            }
            if (JBossSAMLConstants.AUTHN_STATEMENT.get().equalsIgnoreCase(tag)) {
                AuthnStatementType authnStatementType = SAMLParserUtil.parseAuthnStatement(xmlEventReader);
                assertion.addStatement((StatementAbstractType)authnStatementType);
                continue;
            }
            if (JBossSAMLConstants.ATTRIBUTE_STATEMENT.get().equalsIgnoreCase(tag)) {
                AttributeStatementType attributeStatementType = SAMLParserUtil.parseAttributeStatement(xmlEventReader);
                assertion.addStatement((StatementAbstractType)attributeStatementType);
                continue;
            }
            if (JBossSAMLConstants.STATEMENT.get().equalsIgnoreCase(tag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                String xsiTypeValue = StaxParserUtil.getXSITypeValue(startElement);
                if (xsiTypeValue.contains(JBossSAMLConstants.XACML_AUTHZ_DECISION_STATEMENT_TYPE.get())) {
                    XACMLAuthzDecisionStatementType authZStat = new XACMLAuthzDecisionStatementType();
                    startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
                    tag = StaxParserUtil.getStartElementName(startElement);
                    if (tag.contains(JBossSAMLConstants.RESPONSE.get())) {
                        authZStat.setResponse(this.getXACMLResponse(xmlEventReader));
                        startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
                        tag = StaxParserUtil.getStartElementName(startElement);
                        if (tag.contains(JBossSAMLConstants.REQUEST.get())) {
                            authZStat.setRequest(this.getXACMLRequest(xmlEventReader));
                        }
                    }
                    EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                    StaxParserUtil.validate(endElement, JBossSAMLConstants.STATEMENT.get());
                    assertion.addStatement((StatementAbstractType)authZStat);
                    continue;
                }
                throw new RuntimeException("PL0065: Parser : Unknown xsi:type=" + xsiTypeValue);
            }
            throw new RuntimeException("PL00062: Parser : Unknown tag:" + tag + "::location=" + peekedElement.getLocation());
        }
        return assertion;
    }

    public boolean supports(QName qname) {
        String nsURI = qname.getNamespaceURI();
        String localPart = qname.getLocalPart();
        return nsURI.equals(JBossSAMLURIConstants.ASSERTION_NSURI.get()) && localPart.equals(JBossSAMLConstants.ASSERTION.get());
    }

    private AssertionType parseBaseAttributes(StartElement nextElement) throws ParsingException {
        Attribute idAttribute = nextElement.getAttributeByName(new QName(JBossSAMLConstants.ID.get()));
        String id = StaxParserUtil.getAttributeValue(idAttribute);
        Attribute versionAttribute = nextElement.getAttributeByName(new QName(JBossSAMLConstants.VERSION.get()));
        String version = StaxParserUtil.getAttributeValue(versionAttribute);
        StringUtil.match(JBossSAMLConstants.VERSION_2_0.get(), version);
        Attribute issueInstantAttribute = nextElement.getAttributeByName(new QName(JBossSAMLConstants.ISSUE_INSTANT.get()));
        XMLGregorianCalendar issueInstant = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(issueInstantAttribute));
        return new AssertionType(id, issueInstant);
    }

    private ResponseType getXACMLResponse(XMLEventReader xmlEventReader) throws ParsingException {
        Element xacmlResponse = StaxParserUtil.getDOMElement(xmlEventReader);
        String xacmlPath = "org.jboss.security.xacml.core.model.context";
        try {
            JAXBContext jaxb = JAXBContext.newInstance((String)xacmlPath);
            Unmarshaller un = jaxb.createUnmarshaller();
            un.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            JAXBElement jaxbResponseType = (JAXBElement)un.unmarshal(DocumentUtil.getNodeAsStream(xacmlResponse));
            return (ResponseType)jaxbResponseType.getValue();
        }
        catch (Exception e) {
            throw new ParsingException(e);
        }
    }

    private RequestType getXACMLRequest(XMLEventReader xmlEventReader) throws ParsingException {
        Element xacmlRequest = StaxParserUtil.getDOMElement(xmlEventReader);
        String xacmlPath = "org.jboss.security.xacml.core.model.context";
        try {
            JAXBContext jaxb = JAXBContext.newInstance((String)xacmlPath);
            Unmarshaller un = jaxb.createUnmarshaller();
            un.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            JAXBElement jaxbRequestType = (JAXBElement)un.unmarshal(DocumentUtil.getNodeAsStream(xacmlRequest));
            return (RequestType)jaxbRequestType.getValue();
        }
        catch (Exception e) {
            throw new ParsingException(e);
        }
    }
}

