/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.writers;

import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.core.model.context.ResponseType;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.util.SAMLXACMLUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.BaseWriter;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AdviceType;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.AudienceRestrictionType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextClassRefType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextDeclRefType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextDeclType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.saml.v2.assertion.URIType;
import org.picketlink.identity.federation.saml.v2.profiles.xacml.assertion.XACMLAuthzDecisionStatementType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAMLAssertionWriter
extends BaseWriter {
    public SAMLAssertionWriter(XMLStreamWriter writer) {
        super(writer);
    }

    public void write(AssertionType assertion) throws ProcessingException {
        AdviceType advice;
        ConditionsType conditions;
        SubjectType subject;
        Element sig;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.ASSERTION.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ID.get(), assertion.getID());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VERSION.get(), assertion.getVersion());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), assertion.getIssueInstant().toString());
        NameIDType issuer = assertion.getIssuer();
        if (issuer != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = assertion.getSignature()) != null) {
            StaxUtil.writeDOMElement(this.writer, sig);
        }
        if ((subject = assertion.getSubject()) != null) {
            this.write(subject);
        }
        if ((conditions = assertion.getConditions()) != null) {
            StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.CONDITIONS.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.NOT_BEFORE.get(), conditions.getNotBefore().toString());
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.NOT_ON_OR_AFTER.get(), conditions.getNotOnOrAfter().toString());
            List typeOfConditions = conditions.getConditions();
            if (typeOfConditions != null) {
                for (ConditionAbstractType typeCondition : typeOfConditions) {
                    if (!(typeCondition instanceof AudienceRestrictionType)) continue;
                    AudienceRestrictionType art = (AudienceRestrictionType)typeCondition;
                    StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUDIENCE_RESTRICTION.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                    List audiences = art.getAudience();
                    if (audiences != null) {
                        for (URI audience : audiences) {
                            StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUDIENCE.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                            StaxUtil.writeCharacters(this.writer, audience.toString());
                            StaxUtil.writeEndElement(this.writer);
                        }
                    }
                    StaxUtil.writeEndElement(this.writer);
                }
            }
            StaxUtil.writeEndElement(this.writer);
        }
        if ((advice = assertion.getAdvice()) != null) {
            throw new RuntimeException("PL00082: Not Implemented Yet:Advice");
        }
        Set statements = assertion.getStatements();
        if (statements != null) {
            for (StatementAbstractType statement : statements) {
                if (statement instanceof AuthnStatementType) {
                    this.write((AuthnStatementType)statement);
                    continue;
                }
                if (statement instanceof AttributeStatementType) {
                    this.write((AttributeStatementType)statement);
                    continue;
                }
                if (statement instanceof XACMLAuthzDecisionStatementType) {
                    this.write((XACMLAuthzDecisionStatementType)statement);
                    continue;
                }
                throw new RuntimeException("PL00081: Writer: Unknown Type:" + statement.getClass().getName());
            }
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(StatementAbstractType statement) throws ProcessingException {
        throw new RuntimeException("NYI");
    }

    public void write(AttributeStatementType statement) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.ATTRIBUTE_STATEMENT.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        List attributes = statement.getAttributes();
        if (attributes != null) {
            for (AttributeStatementType.ASTChoiceType attr : attributes) {
                EncryptedElementType encType;
                AttributeType attributeType = attr.getAttribute();
                if (attributeType != null) {
                    this.write(attributeType);
                }
                if ((encType = attr.getEncryptedAssertion()) == null) continue;
                throw new RuntimeException("PL00082: Not Implemented Yet:");
            }
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(AuthnStatementType authnStatement) throws ProcessingException {
        AuthnContextType authnContext;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_STATEMENT.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        XMLGregorianCalendar authnInstant = authnStatement.getAuthnInstant();
        if (authnInstant != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.AUTHN_INSTANT.get(), authnInstant.toString());
        }
        if ((authnContext = authnStatement.getAuthnContext()) != null) {
            this.write(authnContext);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(XACMLAuthzDecisionStatementType xacmlStat) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.STATEMENT.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, XACML_SAML_PREFIX, JBossSAMLURIConstants.XACML_SAML_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, XACML_SAML_PROTO_PREFIX, JBossSAMLURIConstants.XACML_SAML_PROTO_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, XSI_PREFIX, JBossSAMLURIConstants.XSI_NSURI.get());
        StaxUtil.writeAttribute(this.writer, new QName(JBossSAMLURIConstants.XSI_NSURI.get(), JBossSAMLConstants.TYPE.get(), XSI_PREFIX), "xacml-saml:XACMLAuthzDecisionStatementType");
        ResponseType responseType = xacmlStat.getResponse();
        if (responseType == null) {
            throw new RuntimeException("PL00083: Writer: Null Value:XACML response");
        }
        Document doc = SAMLXACMLUtil.getXACMLResponse(responseType);
        StaxUtil.writeDOMElement(this.writer, doc.getDocumentElement());
        RequestType requestType = xacmlStat.getRequest();
        if (requestType != null) {
            StaxUtil.writeDOMNode(this.writer, SAMLXACMLUtil.getXACMLRequest(requestType).getDocumentElement());
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(AuthnContextType authContext) throws ProcessingException {
        Set authAuthorities;
        Set uriTypes;
        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
        AuthnContextType.AuthnContextTypeSequence sequence = authContext.getSequence();
        if (sequence != null) {
            AuthnContextClassRefType authnContextClassRefType = sequence.getClassRef();
            if (authnContextClassRefType != null) {
                StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT_CLASS_REF.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeCharacters(this.writer, authnContextClassRefType.getValue().toASCIIString());
                StaxUtil.writeEndElement(this.writer);
            }
            if ((uriTypes = sequence.getURIType()) != null) {
                for (URIType uriType : uriTypes) {
                    if (uriType instanceof AuthnContextDeclType) {
                        StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                        StaxUtil.writeCharacters(this.writer, uriType.getValue().toASCIIString());
                        StaxUtil.writeEndElement(this.writer);
                    }
                    if (!(uriType instanceof AuthnContextDeclRefType)) continue;
                    StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION_REF.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                    StaxUtil.writeCharacters(this.writer, uriType.getValue().toASCIIString());
                    StaxUtil.writeEndElement(this.writer);
                }
            }
        }
        if ((authAuthorities = authContext.getAuthenticatingAuthority()) != null) {
            for (URI aa : authAuthorities) {
                StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHENTICATING_AUTHORITY.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeCharacters(this.writer, aa.toASCIIString());
                StaxUtil.writeEndElement(this.writer);
            }
        }
        uriTypes = authContext.getURIType();
        for (URIType uriType : uriTypes) {
            if (uriType instanceof AuthnContextClassRefType) {
                StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT_CLASS_REF.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeCharacters(this.writer, uriType.getValue().toString());
                StaxUtil.writeEndElement(this.writer);
                continue;
            }
            if (uriType instanceof AuthnContextDeclRefType) {
                StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION_REF.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
                StaxUtil.writeCharacters(this.writer, uriType.getValue().toString());
                StaxUtil.writeEndElement(this.writer);
                continue;
            }
            if (!(uriType instanceof AuthnContextDeclType)) continue;
            StaxUtil.writeStartElement(this.writer, ASSERTION_PREFIX, JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION.get(), JBossSAMLURIConstants.ASSERTION_NSURI.get());
            StaxUtil.writeCharacters(this.writer, uriType.getValue().toString());
            StaxUtil.writeEndElement(this.writer);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }
}

