/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts.registry;

import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class FileBasedSTSOperations {
    private static Logger logger = Logger.getLogger(FileBasedSTSOperations.class);
    protected File directory;

    public FileBasedSTSOperations() {
        StringBuilder builder = new StringBuilder();
        builder.append(System.getProperty("user.home"));
        builder.append(System.getProperty("file.separator") + "picketlink-store");
        builder.append(System.getProperty("file.separator") + "sts");
        this.directory = new File(builder.toString());
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
    }

    protected File create(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:file name");
        }
        File createdFile = new File(fileName);
        if (!createdFile.exists()) {
            try {
                createdFile.createNewFile();
            }
            catch (IOException ioe) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Error creating file: " + ioe.getMessage()));
                }
                ioe.printStackTrace();
            }
        }
        return createdFile;
    }
}

