/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.util;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.config.AuthPropertyType;
import org.picketlink.identity.federation.core.config.ClaimsProcessorType;
import org.picketlink.identity.federation.core.config.IDPType;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.config.KeyValueType;
import org.picketlink.identity.federation.core.config.ProviderType;
import org.picketlink.identity.federation.core.config.SPType;
import org.picketlink.identity.federation.core.config.TokenProviderType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.util.PBEUtils;
import org.picketlink.identity.federation.core.util.SecurityActions;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.metadata.EndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IndexedEndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreConfigUtil {
    private static Logger log = Logger.getLogger(CoreConfigUtil.class);

    public static TrustKeyManager getTrustKeyManager(ProviderType idpOrSPConfiguration) {
        KeyProviderType keyProvider = idpOrSPConfiguration.getKeyProvider();
        return CoreConfigUtil.getTrustKeyManager(keyProvider);
    }

    public static TrustKeyManager getTrustKeyManager(KeyProviderType keyProvider) {
        TrustKeyManager trustKeyManager = null;
        try {
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("PL00092: Null Value:KeyManager class name");
            }
            Class<?> clazz = SecurityActions.loadClass(CoreConfigUtil.class, keyManagerClassName);
            if (clazz == null) {
                throw new RuntimeException("PL00085: Class Not Loaded:" + keyManagerClassName);
            }
            trustKeyManager = (TrustKeyManager)clazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)"Exception in getting TrustKeyManager:", (Throwable)e);
        }
        return trustKeyManager;
    }

    public static PublicKey getValidatingKey(ProviderType idpSpConfiguration, String domain) throws ConfigurationException, ProcessingException {
        TrustKeyManager trustKeyManager = CoreConfigUtil.getTrustKeyManager(idpSpConfiguration);
        return CoreConfigUtil.getValidatingKey(trustKeyManager, domain);
    }

    public static PublicKey getValidatingKey(TrustKeyManager trustKeyManager, String domain) throws ConfigurationException, ProcessingException {
        if (trustKeyManager == null) {
            throw new IllegalArgumentException("PL00092: Null Value:Trust Key Manager");
        }
        return trustKeyManager.getValidatingKey(domain);
    }

    public static List<AuthPropertyType> getKeyProviderProperties(KeyProviderType keyProviderType) throws GeneralSecurityException {
        List authProperties = keyProviderType.getAuth();
        if (CoreConfigUtil.decryptionNeeded(authProperties)) {
            authProperties = CoreConfigUtil.decryptPasswords(authProperties);
        }
        return authProperties;
    }

    public static List<KeyValueType> getProperties(TokenProviderType tokenProviderType) throws GeneralSecurityException {
        List keyValueTypeList = tokenProviderType.getProperty();
        if (CoreConfigUtil.decryptionNeeded(keyValueTypeList)) {
            keyValueTypeList = CoreConfigUtil.decryptPasswords(keyValueTypeList);
        }
        return keyValueTypeList;
    }

    public static List<KeyValueType> getProperties(ClaimsProcessorType claimsProcessorType) throws GeneralSecurityException {
        List keyValueTypeList = claimsProcessorType.getProperty();
        if (CoreConfigUtil.decryptionNeeded(keyValueTypeList)) {
            keyValueTypeList = CoreConfigUtil.decryptPasswords(keyValueTypeList);
        }
        return keyValueTypeList;
    }

    public static boolean decryptionNeeded(List<? extends KeyValueType> keyValueList) {
        int length = keyValueList.size();
        for (int i = 0; i < length; ++i) {
            KeyValueType kvt = keyValueList.get(i);
            String key = kvt.getKey();
            if (!"salt".equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    private static List decryptPasswords(List keyValueList) throws GeneralSecurityException {
        String pbeAlgo = "PBEwithMD5andDES";
        String salt = null;
        int iterationCount = 0;
        int length = keyValueList.size();
        for (int i = 0; i < length; ++i) {
            KeyValueType kvt = (KeyValueType)keyValueList.get(i);
            String key = kvt.getKey();
            if ("salt".equalsIgnoreCase(key)) {
                salt = kvt.getValue();
            }
            if (!"iterationCount".equalsIgnoreCase(key)) continue;
            iterationCount = Integer.parseInt(kvt.getValue());
        }
        if (salt == null) {
            return keyValueList;
        }
        ArrayList<KeyValueType> returningList = new ArrayList<KeyValueType>();
        SecretKeyFactory factory = SecretKeyFactory.getInstance(pbeAlgo);
        char[] password = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt.getBytes(), iterationCount);
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKey cipherKey = factory.generateSecret(keySpec);
        for (int i = 0; i < length; ++i) {
            KeyValueType kvt = (KeyValueType)keyValueList.get(i);
            String val = kvt.getValue();
            if (val.startsWith("MASK-")) {
                String decodedValue;
                val = val.substring("MASK-".length());
                try {
                    decodedValue = PBEUtils.decode64(val, pbeAlgo, cipherKey, cipherSpec);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                KeyValueType newKVT = new KeyValueType();
                if (keyValueList.get(0) instanceof AuthPropertyType) {
                    newKVT = new AuthPropertyType();
                }
                newKVT.setKey(kvt.getKey());
                newKVT.setValue(new String(decodedValue));
                returningList.add(newKVT);
                continue;
            }
            returningList.add(kvt);
        }
        return returningList;
    }

    public static SPType getSPConfiguration(EntityDescriptorType entityDescriptor, String bindingURI) {
        SPType spType = new SPType();
        String identityURL = null;
        String serviceURL = null;
        if (identityURL == null) {
            IDPSSODescriptorType idpSSO = CoreConfigUtil.getIDPDescriptor(entityDescriptor);
            if (idpSSO != null) {
                identityURL = CoreConfigUtil.getIdentityURL(idpSSO, bindingURI);
            }
            spType.setIdentityURL(identityURL);
        }
        if (serviceURL == null) {
            SPSSODescriptorType spSSO = CoreConfigUtil.getSPDescriptor(entityDescriptor);
            if (spSSO != null) {
                serviceURL = CoreConfigUtil.getServiceURL(spSSO, bindingURI);
            }
            spType.setServiceURL(serviceURL);
        }
        return spType;
    }

    public static SPType getSPConfiguration(EntitiesDescriptorType entitiesDescriptor, String bindingURI) {
        SPType spType = null;
        String identityURL = null;
        String serviceURL = null;
        List list = entitiesDescriptor.getEntityDescriptor();
        if (list != null) {
            for (Object theObject : list) {
                if (theObject instanceof EntitiesDescriptorType) {
                    spType = CoreConfigUtil.getSPConfiguration((EntitiesDescriptorType)theObject, bindingURI);
                } else if (theObject instanceof EntityDescriptorType) {
                    if (identityURL == null) {
                        IDPSSODescriptorType idpSSO = CoreConfigUtil.getIDPDescriptor((EntityDescriptorType)theObject);
                        if (idpSSO != null) {
                            identityURL = CoreConfigUtil.getIdentityURL(idpSSO, bindingURI);
                        }
                        if (identityURL != null && spType != null) {
                            spType.setIdentityURL(identityURL);
                        } else if (identityURL != null && spType == null) {
                            spType = new SPType();
                            spType.setIdentityURL(identityURL);
                        }
                    }
                    if (serviceURL == null) {
                        SPSSODescriptorType spSSO = CoreConfigUtil.getSPDescriptor((EntityDescriptorType)theObject);
                        if (spSSO != null) {
                            serviceURL = CoreConfigUtil.getServiceURL(spSSO, bindingURI);
                        }
                        if (serviceURL != null && spType != null) {
                            spType.setServiceURL(serviceURL);
                        } else if (serviceURL != null && spType == null) {
                            spType = new SPType();
                            spType.setServiceURL(serviceURL);
                        }
                    }
                }
                if (spType == null || StringUtil.isNullOrEmpty(spType.getIdentityURL()) || StringUtil.isNullOrEmpty(spType.getServiceURL())) continue;
                break;
            }
        }
        return spType;
    }

    public static IDPSSODescriptorType getIDPDescriptor(EntitiesDescriptorType entitiesDescriptor) {
        IDPSSODescriptorType idp = null;
        List entitiesList = entitiesDescriptor.getEntityDescriptor();
        for (Object theObject : entitiesList) {
            if (theObject instanceof EntitiesDescriptorType) {
                idp = CoreConfigUtil.getIDPDescriptor((EntitiesDescriptorType)theObject);
            } else if (theObject instanceof EntityDescriptorType) {
                idp = CoreConfigUtil.getIDPDescriptor((EntityDescriptorType)theObject);
            }
            if (idp == null) continue;
            break;
        }
        return idp;
    }

    public static IDPSSODescriptorType getIDPDescriptor(EntityDescriptorType entityDescriptor) {
        List edtChoices = entityDescriptor.getChoiceType();
        for (EntityDescriptorType.EDTChoiceType edt : edtChoices) {
            List edtDescriptors = edt.getDescriptors();
            for (EntityDescriptorType.EDTDescriptorChoiceType edtDesc : edtDescriptors) {
                IDPSSODescriptorType idpSSO = edtDesc.getIdpDescriptor();
                if (idpSSO == null) continue;
                return idpSSO;
            }
        }
        return null;
    }

    public static SPSSODescriptorType getSPDescriptor(EntityDescriptorType entityDescriptor) {
        List edtChoices = entityDescriptor.getChoiceType();
        for (EntityDescriptorType.EDTChoiceType edt : edtChoices) {
            List edtDescriptors = edt.getDescriptors();
            for (EntityDescriptorType.EDTDescriptorChoiceType edtDesc : edtDescriptors) {
                SPSSODescriptorType spSSO = edtDesc.getSpDescriptor();
                if (spSSO == null) continue;
                return spSSO;
            }
        }
        return null;
    }

    public static String getIdentityURL(IDPSSODescriptorType idp, String bindingURI) {
        String identityURL = null;
        List endpoints = idp.getSingleSignOnService();
        for (EndpointType endpoint : endpoints) {
            if (!endpoint.getBinding().toString().equals(bindingURI)) continue;
            identityURL = endpoint.getLocation().toString();
            break;
        }
        return identityURL;
    }

    public static String getServiceURL(SPSSODescriptorType sp, String bindingURI) {
        String serviceURL = null;
        List endpoints = sp.getAssertionConsumerService();
        for (IndexedEndpointType endpoint : endpoints) {
            if (!endpoint.getBinding().toString().equals(bindingURI)) continue;
            serviceURL = endpoint.getLocation().toString();
            break;
        }
        return serviceURL;
    }

    public static IDPType getIDPType(IDPSSODescriptorType idpSSODescriptor) {
        IDPType idp = new IDPType();
        List endpoints = idpSSODescriptor.getSingleSignOnService();
        if (endpoints != null) {
            for (EndpointType endpoint : endpoints) {
                if (!endpoint.getBinding().toString().equals(JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get())) continue;
                idp.setIdentityURL(endpoint.getLocation().toString());
                break;
            }
        }
        if (StringUtil.isNullOrEmpty(idp.getIdentityURL())) {
            throw new IllegalStateException("PL00092: Null Value:identity url");
        }
        return idp;
    }
}

