/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.annotation.Resource;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import org.apache.log4j.Logger;
import org.picketlink.identity.federation.core.config.STSType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.parsers.sts.STSConfigParser;
import org.picketlink.identity.federation.core.parsers.wst.WSTrustParser;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.SOAPUtil;
import org.picketlink.identity.federation.core.wstrust.PicketLinkSTSConfiguration;
import org.picketlink.identity.federation.core.wstrust.STSConfiguration;
import org.picketlink.identity.federation.core.wstrust.SecurityActions;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.WSTrustRequestHandler;
import org.picketlink.identity.federation.core.wstrust.wrappers.BaseRequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenCollection;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponseCollection;
import org.picketlink.identity.federation.core.wstrust.writers.WSTrustResponseWriter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebServiceProvider(serviceName="PicketLinkSTS", portName="PicketLinkSTSPort", targetNamespace="urn:picketlink:identity-federation:sts", wsdlLocation="WEB-INF/wsdl/PicketLinkSTS.wsdl")
@ServiceMode(value=Service.Mode.MESSAGE)
public class PicketLinkSTS
implements Provider<SOAPMessage> {
    private static Logger logger = Logger.getLogger(PicketLinkSTS.class);
    private static final String SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("file.separator");
        }
    });
    private static final String STS_CONFIG_FILE = "picketlink-sts.xml";
    private static final String STS_CONFIG_DIR = "picketlink-store" + SEPARATOR + "sts" + SEPARATOR;
    @Resource
    protected WebServiceContext context;
    protected STSConfiguration config;
    public static ThreadLocal<BinaryToken> binaryToken = new InheritableThreadLocal<BinaryToken>();

    public SOAPMessage invoke(SOAPMessage request) {
        BaseRequestSecurityToken baseRequest;
        Document payLoad;
        Node binaryToken;
        String valueType;
        block11: {
            valueType = null;
            binaryToken = null;
            try {
                SOAPHeader soapHeader = request.getSOAPHeader();
                binaryToken = this.getBinaryToken(soapHeader);
                if (binaryToken == null) break block11;
                NamedNodeMap namedNodeMap = binaryToken.getAttributes();
                int length = namedNodeMap != null ? namedNodeMap.getLength() : 0;
                for (int i = 0; i < length; ++i) {
                    Node nodeValueType = namedNodeMap.getNamedItem("ValueType");
                    if (nodeValueType == null) continue;
                    valueType = nodeValueType.getNodeValue();
                    break;
                }
            }
            catch (SOAPException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
        try {
            payLoad = SOAPUtil.getSOAPData(request);
            WSTrustParser parser = new WSTrustParser();
            baseRequest = (BaseRequestSecurityToken)parser.parse(DocumentUtil.getNodeAsStream(payLoad));
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        if (baseRequest instanceof RequestSecurityToken) {
            RequestSecurityToken req = (RequestSecurityToken)baseRequest;
            try {
                req.setRSTDocument(payLoad);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (binaryToken != null) {
                req.setBinaryToken(binaryToken);
            }
            if (valueType != null) {
                req.setBinaryValueType(URI.create(valueType));
            }
            Source theResponse = this.handleTokenRequest(req);
            return this.convert(theResponse);
        }
        if (baseRequest instanceof RequestSecurityTokenCollection) {
            return this.convert(this.handleTokenRequestCollection((RequestSecurityTokenCollection)baseRequest));
        }
        throw new WebServiceException("PL00001: Invalid security token request");
    }

    private SOAPMessage convert(Source theResponse) {
        try {
            SOAPMessage response = SOAPUtil.create();
            Document theResponseDoc = (Document)DocumentUtil.getNodeFromSource(theResponse);
            response.getSOAPBody().addDocument(theResponseDoc);
            return response;
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private Node getBinaryToken(SOAPHeader soapHeader) {
        if (soapHeader != null) {
            NodeList children = soapHeader.getChildNodes();
            int length = children != null ? children.getLength() : 0;
            for (int i = 0; i < length; ++i) {
                Node child = children.item(i);
                if (!child.getNodeName().contains("BinarySecurityToken")) continue;
                return child;
            }
        }
        return null;
    }

    protected Source handleTokenRequest(RequestSecurityToken request) {
        WSTrustRequestHandler handler;
        if (this.context == null) {
            throw new IllegalStateException("PL00092: Null Value:WebServiceContext");
        }
        if (this.config == null) {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Loading STS configuration");
                }
                this.config = this.getConfiguration();
            }
            catch (ConfigurationException e) {
                throw new WebServiceException("PL00002: Encountered configuration exception:", (Throwable)e);
            }
        }
        if ((handler = this.config.getRequestHandler()) == null) {
            throw new IllegalStateException("PL00092: Null Value:WSTrustRequestHandler");
        }
        String requestType = request.getRequestType().toString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("STS received request of type " + requestType));
        }
        try {
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue")) {
                Source source = this.marshallResponse(handler.issue(request, this.context.getUserPrincipal()));
                Document doc = handler.postProcess((Document)((DOMSource)source).getNode(), request);
                return new DOMSource(doc);
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew")) {
                Source source = this.marshallResponse(handler.renew(request, this.context.getUserPrincipal()));
                Document document = handler.postProcess((Document)((DOMSource)source).getNode(), request);
                return new DOMSource(document);
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel")) {
                return this.marshallResponse(handler.cancel(request, this.context.getUserPrincipal()));
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate")) {
                return this.marshallResponse(handler.validate(request, this.context.getUserPrincipal()));
            }
            throw new WSTrustException("PL00001: Invalid request type: " + requestType);
        }
        catch (WSTrustException we) {
            throw new WebServiceException("PL00003: Exception in handling token request: " + we.getMessage(), (Throwable)we);
        }
    }

    protected Source handleTokenRequestCollection(RequestSecurityTokenCollection requestCollection) {
        throw new UnsupportedOperationException();
    }

    protected Source marshallResponse(RequestSecurityTokenResponse response) {
        RequestSecurityTokenResponseCollection responseCollection = new RequestSecurityTokenResponseCollection();
        responseCollection.addRequestSecurityTokenResponse(response);
        try {
            DOMResult result = new DOMResult(DocumentUtil.createDocument());
            WSTrustResponseWriter writer = new WSTrustResponseWriter(result);
            writer.write(responseCollection);
            return new DOMSource(result.getNode());
        }
        catch (Exception e) {
            throw new WebServiceException("PL00004: Error writing response: " + e.getMessage(), (Throwable)e);
        }
    }

    protected STSConfiguration getConfiguration() throws ConfigurationException {
        URL configurationFileURL = null;
        try {
            String configurationFilePath = System.getProperty("user.home") + SEPARATOR + STS_CONFIG_DIR + STS_CONFIG_FILE;
            File configurationFile = new File(configurationFilePath);
            configurationFileURL = configurationFile.exists() ? configurationFile.toURI().toURL() : SecurityActions.loadResource(this.getClass(), STS_CONFIG_FILE);
            if (configurationFileURL == null) {
                logger.warn((Object)"picketlink-sts.xml configuration file not found. Using default configuration values");
                return new PicketLinkSTSConfiguration();
            }
            InputStream stream = configurationFileURL.openStream();
            STSType stsConfig = (STSType)new STSConfigParser().parse(stream);
            PicketLinkSTSConfiguration configuration = new PicketLinkSTSConfiguration(stsConfig);
            if (logger.isInfoEnabled()) {
                logger.info((Object)"picketlink-sts.xml configuration file loaded");
            }
            return configuration;
        }
        catch (Exception e) {
            throw new ConfigurationException("PL00005: Error parsing the configuration file:" + configurationFileURL + "]", e);
        }
    }

    public static class BinaryToken {
        public Node token;
    }
}

