/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential;

import java.security.MessageDigest;
import org.picketlink.idm.credential.DigestCredential;

public class DigestCredentialUtil {
    private static final String UTF8 = "UTF-8";
    private static final String MD5_ALGORITHM = "MD5";

    public static byte[] md5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance(MD5_ALGORITHM);
            return md.digest(str.getBytes(UTF8));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String clientResponseValue(DigestCredential digest, char[] password) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(MD5_ALGORITHM);
            messageDigest.update(digest.getUsername().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getRealm().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(new String(password).getBytes(UTF8));
            byte[] ha1 = messageDigest.digest();
            messageDigest.reset();
            messageDigest.update(digest.getMethod().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getUri().getBytes(UTF8));
            byte[] ha2 = messageDigest.digest();
            messageDigest.update(DigestCredentialUtil.convertBytesToHex(ha1).getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getNonce().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getNc().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getCnonce().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(digest.getQop().getBytes(UTF8));
            messageDigest.update((byte)58);
            messageDigest.update(DigestCredentialUtil.convertBytesToHex(ha2).getBytes(UTF8));
            byte[] digestedValue = messageDigest.digest();
            return DigestCredentialUtil.convertBytesToHex(digestedValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean matchCredential(DigestCredential digest, char[] password) {
        return DigestCredentialUtil.clientResponseValue(digest, password).equalsIgnoreCase(digest.getClientResponse());
    }

    public static String convertBytesToHex(byte[] bytes) {
        int base = 16;
        int ALL_ON = 255;
        StringBuilder buf = new StringBuilder();
        for (byte byteValue : bytes) {
            int bit = ALL_ON & byteValue;
            int c = 48 + bit / base % base;
            if (c > 57) {
                c = 97 + (c - 48 - 10);
            }
            buf.append((char)c);
            c = 48 + bit % base;
            if (c > 57) {
                c = 97 + (c - 48 - 10);
            }
            buf.append((char)c);
        }
        return buf.toString();
    }
}

