/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.spi;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.credential.Credential;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Membership;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.GroupQuery;
import org.picketlink.idm.query.MembershipQuery;
import org.picketlink.idm.query.Range;
import org.picketlink.idm.query.RoleQuery;
import org.picketlink.idm.query.UserQuery;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

public interface IdentityStore {
    public Set<Feature> getFeatureSet();

    public void createUser(IdentityStoreInvocationContext var1, User var2);

    public void removeUser(IdentityStoreInvocationContext var1, User var2);

    public User getUser(IdentityStoreInvocationContext var1, String var2);

    public Group createGroup(IdentityStoreInvocationContext var1, String var2, Group var3);

    public void removeGroup(IdentityStoreInvocationContext var1, Group var2);

    public Group getGroup(IdentityStoreInvocationContext var1, String var2);

    public Role createRole(IdentityStoreInvocationContext var1, String var2);

    public void removeRole(IdentityStoreInvocationContext var1, Role var2);

    public Role getRole(IdentityStoreInvocationContext var1, String var2);

    public Membership createMembership(IdentityStoreInvocationContext var1, IdentityType var2, Group var3, Role var4);

    public void removeMembership(IdentityStoreInvocationContext var1, IdentityType var2, Group var3, Role var4);

    public Membership getMembership(IdentityStoreInvocationContext var1, IdentityType var2, Group var3, Role var4);

    public List<User> executeQuery(IdentityStoreInvocationContext var1, UserQuery var2, Range var3);

    public List<Group> executeQuery(IdentityStoreInvocationContext var1, GroupQuery var2, Range var3);

    public List<Role> executeQuery(IdentityStoreInvocationContext var1, RoleQuery var2, Range var3);

    public List<Membership> executeQuery(IdentityStoreInvocationContext var1, MembershipQuery var2, Range var3);

    public boolean validateCredential(IdentityStoreInvocationContext var1, User var2, Credential var3);

    public void updateCredential(IdentityStoreInvocationContext var1, User var2, Credential var3);

    public void setAttribute(IdentityStoreInvocationContext var1, IdentityType var2, String var3, String[] var4);

    public void removeAttribute(IdentityStoreInvocationContext var1, IdentityType var2, String var3);

    public String[] getAttributeValues(IdentityStoreInvocationContext var1, IdentityType var2, String var3);

    public Map<String, String[]> getAttributes(IdentityStoreInvocationContext var1, IdentityType var2);

    public static enum Feature {
        createUser,
        readUser,
        updateUser,
        deleteUser,
        createGroup,
        readGroup,
        updateGroup,
        deleteGroup,
        createRole,
        readRole,
        updateRole,
        deleteRole,
        createMembership,
        readMembership,
        updateMembership,
        deleteMembership,
        all;

    }
}

