/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.DigestCredentialHandler;
import org.picketlink.idm.credential.internal.PasswordCredentialHandler;
import org.picketlink.idm.credential.internal.X509CertificateCredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.CredentialHandlers;
import org.picketlink.idm.event.AgentCreatedEvent;
import org.picketlink.idm.event.AgentDeletedEvent;
import org.picketlink.idm.event.AgentUpdatedEvent;
import org.picketlink.idm.event.GroupCreatedEvent;
import org.picketlink.idm.event.GroupDeletedEvent;
import org.picketlink.idm.event.GroupUpdatedEvent;
import org.picketlink.idm.event.RelationshipCreatedEvent;
import org.picketlink.idm.event.RelationshipDeletedEvent;
import org.picketlink.idm.event.RelationshipUpdatedEvent;
import org.picketlink.idm.event.RoleCreatedEvent;
import org.picketlink.idm.event.RoleDeletedEvent;
import org.picketlink.idm.event.RoleUpdatedEvent;
import org.picketlink.idm.event.UserCreatedEvent;
import org.picketlink.idm.event.UserDeletedEvent;
import org.picketlink.idm.event.UserUpdatedEvent;
import org.picketlink.idm.file.internal.FileCredentialStore;
import org.picketlink.idm.file.internal.FileIdentityQueryHelper;
import org.picketlink.idm.file.internal.FileIdentityStoreConfiguration;
import org.picketlink.idm.file.internal.FilePartitionStore;
import org.picketlink.idm.file.internal.FileRelationshipStorage;
import org.picketlink.idm.internal.util.IDMUtil;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.internal.util.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.NamedPropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.PropertyQueries;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleAgent;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.model.User;
import org.picketlink.idm.model.annotation.RelationshipIdentity;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.RelationshipQueryParameter;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.PartitionStore;

@CredentialHandlers(value={PasswordCredentialHandler.class, X509CertificateCredentialHandler.class, DigestCredentialHandler.class})
public class FileBasedIdentityStore
implements IdentityStore<FileIdentityStoreConfiguration>,
CredentialStore,
PartitionStore {
    private FileIdentityStoreConfiguration config;
    private IdentityStoreInvocationContext context;
    private FileCredentialStore credentialStore;
    private FilePartitionStore partitionStore;

    public void setup(FileIdentityStoreConfiguration config, IdentityStoreInvocationContext context) {
        this.config = config;
        this.context = context;
        this.credentialStore = new FileCredentialStore(this);
        this.partitionStore = new FilePartitionStore(this);
        if (this.context.getRealm() == null) {
            this.context.setRealm(this.getRealm("default"));
        }
    }

    public FileIdentityStoreConfiguration getConfig() {
        return this.config;
    }

    public IdentityStoreInvocationContext getContext() {
        return this.context;
    }

    private Partition getCurrentPartition() {
        return this.getContext().getPartition();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(AttributedType attributedType) {
        attributedType.setId(this.getContext().getIdGenerator().generate());
        if (IdentityType.class.isInstance(attributedType)) {
            Class<?> identityTypeClass = attributedType.getClass();
            if (IDMUtil.isAgentType(identityTypeClass)) {
                Agent agent = (Agent)attributedType;
                if (agent.getLoginName() == null) {
                    throw new IdentityManagementException("No login name was provided.");
                }
                if (this.getAgent(agent.getLoginName()) != null) {
                    throw new IdentityManagementException("Agent already exists with the given login name [" + agent.getLoginName() + "] for the given Realm [" + this.getContext().getRealm().getName() + "]");
                }
                if (IDMUtil.isUserType(identityTypeClass)) {
                    this.addUser((User)agent);
                    return;
                } else {
                    this.addAgent(agent);
                }
                return;
            } else if (IDMUtil.isGroupType(identityTypeClass)) {
                this.addGroup((Group)attributedType);
                return;
            } else {
                if (!IDMUtil.isRoleType(identityTypeClass)) throw this.createUnsupportedIdentityTypeException(identityTypeClass);
                this.addRole((Role)attributedType);
            }
            return;
        } else {
            if (!Relationship.class.isInstance(attributedType)) throw this.createUnsupportedAttributedType(attributedType.getClass());
            this.addRelationship((Relationship)attributedType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(AttributedType attributedType) {
        this.checkNotNulId(attributedType);
        if (IdentityType.class.isInstance(attributedType)) {
            Class<?> identityTypeClass = attributedType.getClass();
            if (IDMUtil.isUserType(identityTypeClass)) {
                this.updateUser((User)attributedType);
                return;
            } else if (IDMUtil.isAgentType(identityTypeClass)) {
                this.updateAgent((Agent)attributedType);
                return;
            } else if (IDMUtil.isGroupType(identityTypeClass)) {
                this.updateGroup((Group)attributedType);
                return;
            } else {
                if (!IDMUtil.isRoleType(identityTypeClass)) throw this.createUnsupportedIdentityTypeException(identityTypeClass);
                this.updateRole((Role)attributedType);
            }
            return;
        } else {
            if (!Relationship.class.isInstance(attributedType)) throw this.createUnsupportedAttributedType(attributedType.getClass());
            this.updateRelationship((Relationship)attributedType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove(AttributedType attributedType) {
        this.checkNotNulId(attributedType);
        Class<?> attributedTypeClass = attributedType.getClass();
        if (IdentityType.class.isInstance(attributedType)) {
            if (IDMUtil.isAgentType(attributedTypeClass)) {
                this.removeAgent((Agent)attributedType);
                return;
            } else if (IDMUtil.isGroupType(attributedTypeClass)) {
                this.removeGroup((Group)attributedType);
                return;
            } else {
                if (!IDMUtil.isRoleType(attributedTypeClass)) throw this.createUnsupportedIdentityTypeException(attributedTypeClass);
                this.removeRole((Role)attributedType);
            }
            return;
        } else {
            if (!Relationship.class.isInstance(attributedType)) throw this.createUnsupportedAttributedType(attributedTypeClass);
            this.removeRelationship((Relationship)attributedType);
        }
    }

    public Agent getAgent(String loginName) {
        return this.getAgentsForCurrentRealm().get(loginName);
    }

    public User getUser(String loginName) {
        Agent agent = this.getAgent(loginName);
        if (!User.class.isInstance(agent)) {
            return null;
        }
        return (User)agent;
    }

    public Role getRole(String roleName) {
        return this.lookupRole(roleName, this.getCurrentPartition());
    }

    public Group getGroup(String groupName) {
        return this.lookupGroup(groupName, this.getCurrentPartition());
    }

    public Group getGroup(String name, Group parent) {
        Group group = this.getGroup(name);
        Group parentGroup = group.getParentGroup();
        if (parentGroup == null || !parentGroup.getName().equals(parent.getName())) {
            group = null;
        }
        return group;
    }

    public <T extends IdentityType> int countQueryResults(IdentityQuery<T> identityQuery) {
        int limit = identityQuery.getLimit();
        int offset = identityQuery.getOffset();
        identityQuery.setLimit(0);
        identityQuery.setOffset(0);
        int resultCount = identityQuery.getResultList().size();
        identityQuery.setLimit(limit);
        identityQuery.setOffset(offset);
        return resultCount;
    }

    public <T extends Serializable> Attribute<T> getAttribute(IdentityType identityType, String attributeName) {
        throw this.createNotImplementedYetException();
    }

    public void setAttribute(IdentityType identityType, Attribute<? extends Serializable> attribute) {
        throw this.createNotImplementedYetException();
    }

    public void removeAttribute(IdentityType identityType, String attributeName) {
        throw this.createNotImplementedYetException();
    }

    public <T extends Relationship> List<T> fetchQueryResults(RelationshipQuery<T> query) {
        ArrayList<T> result = new ArrayList<T>();
        Class relationshipType = query.getRelationshipType();
        List<FileRelationshipStorage> relationships = this.getRelationshipsForCurrentPartition().get(relationshipType.getName());
        if (relationships == null) {
            return result;
        }
        for (FileRelationshipStorage storedRelationship : relationships) {
            boolean match = false;
            if (query.getRelationshipType().getName().equals(storedRelationship.getType())) {
                Set parameters = query.getParameters().entrySet();
                for (Map.Entry entry : parameters) {
                    QueryParameter queryParameter = (QueryParameter)entry.getKey();
                    Object[] values = (Object[])entry.getValue();
                    if (entry.getKey() instanceof RelationshipQueryParameter) {
                        RelationshipQueryParameter identityTypeParameter = (RelationshipQueryParameter)entry.getKey();
                        int valuesMathCount = values.length;
                        IdentityType identityTypeRel = storedRelationship.getIdentityTypes().get(identityTypeParameter.getName());
                        for (Object object : values) {
                            IdentityType identityType = (IdentityType)object;
                            if (!identityTypeRel.getClass().isInstance(identityType) || !identityTypeRel.getId().equals(identityType.getId())) continue;
                            --valuesMathCount;
                        }
                        boolean bl = match = valuesMathCount <= 0;
                    }
                    if (AttributedType.AttributeParameter.class.isInstance(queryParameter) && values != null) {
                        AttributedType.AttributeParameter customParameter = (AttributedType.AttributeParameter)queryParameter;
                        Serializable userAttributeValue = storedRelationship.getAttributes().get(customParameter.getName());
                        if (userAttributeValue != null) {
                            int count = values.length;
                            for (Object value : values) {
                                if (userAttributeValue.getClass().isArray()) {
                                    Object[] userValues;
                                    for (Object object : userValues = (Object[])userAttributeValue) {
                                        if (!object.equals(value)) continue;
                                        --count;
                                    }
                                    continue;
                                }
                                if (!value.equals(userAttributeValue)) continue;
                                --count;
                            }
                            boolean bl = match = count <= 0;
                        }
                    }
                    if (match) continue;
                    break;
                }
            }
            if (!match) continue;
            result.add(this.convertToRelationship(storedRelationship));
        }
        return result;
    }

    public <T extends Relationship> int countQueryResults(RelationshipQuery<T> query) {
        throw this.createNotImplementedYetException();
    }

    public <T extends IdentityType> List<T> fetchQueryResults(IdentityQuery<T> identityQuery) {
        Class identityTypeClass = identityQuery.getIdentityType();
        Set<Map.Entry<String, Object>> entries = null;
        Object[] partitionParameters = identityQuery.getParameter(IdentityType.PARTITION);
        Partition partition = null;
        if (partitionParameters != null && partitionParameters.length > 0) {
            partition = (Partition)partitionParameters[0];
        }
        if (IdentityType.class.equals((Object)identityTypeClass)) {
            HashMap<String, Object> allIdentityTypes = new HashMap<String, Object>();
            if (partition == null) {
                allIdentityTypes.putAll(this.getAgentsForCurrentRealm());
                allIdentityTypes.putAll(this.getRolesForCurrentPartition());
                allIdentityTypes.putAll(this.getGroupsForCurrentPartition());
            } else {
                allIdentityTypes.putAll(this.getAgentsForPartition(partition));
                allIdentityTypes.putAll(this.getRolesForPartition(partition));
                allIdentityTypes.putAll(this.getGroupsForPartition(partition));
            }
            entries = allIdentityTypes.entrySet();
        } else if (IDMUtil.isAgentType(identityTypeClass)) {
            entries = partition == null ? this.getAgentsForCurrentRealm().entrySet() : this.getAgentsForPartition(partition).entrySet();
        } else if (IDMUtil.isRoleType(identityTypeClass)) {
            entries = partition == null ? this.getRolesForCurrentPartition().entrySet() : this.getRolesForPartition(partition).entrySet();
        } else if (IDMUtil.isGroupType(identityTypeClass)) {
            entries = partition == null ? this.getGroupsForCurrentPartition().entrySet() : this.getGroupsForPartition(partition).entrySet();
        } else {
            throw this.createUnsupportedIdentityTypeException(identityTypeClass);
        }
        ArrayList<IdentityType> result = new ArrayList<IdentityType>();
        int typesCount = 0;
        for (Map.Entry<String, Agent> entry : entries) {
            Map attributeParameters;
            FileIdentityQueryHelper queryHelper;
            Role role;
            User user;
            Agent agent;
            IdentityType storedEntry = (IdentityType)entry.getValue();
            if (!identityTypeClass.isAssignableFrom(storedEntry.getClass())) continue;
            ++typesCount;
            if (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, IdentityType.ID, (Serializable)((Object)storedEntry.getId())) || IDMUtil.isAgentType(identityTypeClass) && (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, Agent.LOGIN_NAME, (Serializable)((Object)(agent = (Agent)storedEntry).getLoginName())) || IDMUtil.isUserType(identityTypeClass) && (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, User.EMAIL, (Serializable)((Object)(user = (User)storedEntry).getEmail())) || !FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, User.FIRST_NAME, (Serializable)((Object)user.getFirstName())) || !FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, User.LAST_NAME, (Serializable)((Object)user.getLastName())))) || IDMUtil.isRoleType(identityTypeClass) && !FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, Role.NAME, (Serializable)((Object)(role = (Role)storedEntry).getName()))) continue;
            if (IDMUtil.isGroupType(identityTypeClass)) {
                Group group = (Group)storedEntry;
                if (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, Group.NAME, (Serializable)((Object)group.getName()))) continue;
                String parentGroupName = null;
                if (group.getParentGroup() != null) {
                    parentGroupName = group.getParentGroup().getName();
                }
                if (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, Group.PARENT, (Serializable)((Object)parentGroupName))) continue;
            }
            if (!FileIdentityQueryHelper.isQueryParameterEquals(identityQuery, IdentityType.ENABLED, Boolean.valueOf(storedEntry.isEnabled())) || !(queryHelper = new FileIdentityQueryHelper(identityQuery, this)).matchCreatedDateParameters(storedEntry) || !queryHelper.matchExpiryDateParameters(storedEntry) || !(attributeParameters = identityQuery.getParameters(AttributedType.AttributeParameter.class)).isEmpty() && !queryHelper.matchAttributes(storedEntry, attributeParameters) || !queryHelper.matchHasRole(storedEntry) || !queryHelper.matchMemberOf(storedEntry) || !queryHelper.matchHasGroupRole(storedEntry) || !queryHelper.matchRolesOf(storedEntry) || !queryHelper.matchHasMember(storedEntry)) continue;
            if (identityQuery.getLimit() > 0) {
                if (result.size() == identityQuery.getLimit()) {
                    return result;
                }
                if (identityQuery.getOffset() > 0 && typesCount <= identityQuery.getOffset()) continue;
            }
            result.add(storedEntry);
        }
        return result;
    }

    public void storeCredential(Agent agent, CredentialStorage storage) {
        this.credentialStore.storeCredential(agent, storage);
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(Agent agent, Class<T> storageClass) {
        return this.credentialStore.retrieveCredentials(agent, storageClass);
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(Agent agent, Class<T> storageClass) {
        return this.credentialStore.retrieveCurrentCredential(agent, storageClass);
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        this.credentialStore.updateCredential(agent, credential, effectiveDate, expiryDate);
    }

    public void validateCredentials(Credentials credentials) {
        this.credentialStore.validateCredentials(credentials);
    }

    public void createPartition(Partition partition) {
        this.partitionStore.createPartition(partition);
    }

    public Realm getRealm(String realmName) {
        return this.partitionStore.getRealm(realmName);
    }

    public Tier getTier(String tierName) {
        return this.partitionStore.getTier(tierName);
    }

    public void removePartition(Partition partition) {
        this.partitionStore.removePartition(partition);
    }

    protected <T extends Relationship> T convertToRelationship(FileRelationshipStorage storedRelationship) {
        Relationship relationship = null;
        Class<?> relationshipType = null;
        try {
            relationshipType = Class.forName(storedRelationship.getType());
        }
        catch (ClassNotFoundException e1) {
            throw new IdentityManagementException("Could not get Relationship type [" + storedRelationship.getType() + "]");
        }
        try {
            relationship = (Relationship)relationshipType.newInstance();
            relationship.setId(storedRelationship.getId());
            Set<Map.Entry<String, IdentityType>> identityTypes = storedRelationship.getIdentityTypes().entrySet();
            for (Map.Entry<String, IdentityType> entry : identityTypes) {
                List annotatedTypes = PropertyQueries.createQuery(relationshipType).addCriteria(new NamedPropertyCriteria(entry.getKey())).getResultList();
                Property<IdentityType> property = annotatedTypes.get(0);
                property.setValue(relationship, entry.getValue());
            }
            Set<Map.Entry<String, Serializable>> attributes = storedRelationship.getAttributes().entrySet();
            for (Map.Entry<String, Serializable> entry : attributes) {
                relationship.setAttribute(new Attribute(entry.getKey(), entry.getValue()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return (T)relationship;
    }

    private Role lookupRole(Role role) throws IdentityManagementException {
        if (role.getName() == null) {
            throw new IdentityManagementException("No identifier was provided.");
        }
        Role storedRole = this.getRole(role.getName());
        if (storedRole == null) {
            throw new IdentityManagementException("No Role found with the given name [" + role.getName() + "] for the current Partition [" + this.getCurrentPartition().getName() + "].");
        }
        return storedRole;
    }

    private Group lookupGroup(Group group) throws IdentityManagementException {
        if (group.getName() == null) {
            throw new IdentityManagementException("No identifier was provided.");
        }
        Group storedGroup = this.getGroup(group.getName());
        if (storedGroup == null) {
            throw new IdentityManagementException("No Group found with the given name [" + group.getName() + "] for the current Partition [" + this.getCurrentPartition().getName() + "].");
        }
        return storedGroup;
    }

    private Agent lookupAgent(Agent agent) throws IdentityManagementException {
        if (agent.getLoginName() == null) {
            throw new IdentityManagementException("No identifier was provided.");
        }
        Agent storedAgent = this.getAgent(agent.getLoginName());
        if (storedAgent == null) {
            throw new IdentityManagementException("No Agent found with the given loginName [" + agent.getLoginName() + "] for the current Partition [" + this.getContext().getRealm().getName() + "]");
        }
        return storedAgent;
    }

    private User lookupUser(User user) throws IdentityManagementException {
        if (user.getLoginName() == null) {
            throw new IdentityManagementException("No login name was provided.");
        }
        User storedUser = this.getUser(user.getLoginName());
        if (storedUser == null) {
            throw new IdentityManagementException("No User found with the given login name [" + user.getLoginName() + "] for the current Partition [" + this.getContext().getRealm().getName() + "]");
        }
        return storedUser;
    }

    private void addRole(Role role) {
        if (role.getName() == null) {
            throw new IdentityManagementException("No name was provided.");
        }
        if (this.getRole(role.getName()) != null) {
            throw new IdentityManagementException("Role already exists with the given name [" + role.getName() + "] for the given Partition [" + this.getCurrentPartition().getName() + "]");
        }
        SimpleRole fileRole = new SimpleRole(role.getName());
        fileRole.setPartition(this.getCurrentPartition());
        this.updateIdentityType((IdentityType)role, (IdentityType)fileRole);
        this.getRolesForCurrentPartition().put(fileRole.getName(), (Role)fileRole);
        this.flushRoles();
        this.getContext().getEventBridge().raiseEvent((Object)new RoleCreatedEvent(role));
    }

    private void addGroup(Group group) {
        if (group.getName() == null) {
            throw new IdentityManagementException("No name was provided.");
        }
        if (this.getGroup(group.getName()) != null) {
            throw new IdentityManagementException("Group already exists with the given name [" + group.getName() + "] for the given Partition [" + this.getCurrentPartition().getName() + "]");
        }
        SimpleGroup fileGroup = null;
        fileGroup = group.getParentGroup() != null ? new SimpleGroup(group.getName(), this.lookupGroup(group.getParentGroup())) : new SimpleGroup(group.getName());
        fileGroup.setPartition(this.getCurrentPartition());
        this.updateIdentityType((IdentityType)group, (IdentityType)fileGroup);
        this.getGroupsForCurrentPartition().put(fileGroup.getName(), (Group)fileGroup);
        this.flushGroups();
        this.getContext().getEventBridge().raiseEvent((Object)new GroupCreatedEvent(group));
    }

    private void addUser(User user) {
        SimpleUser storedUser = new SimpleUser(user.getLoginName());
        storedUser.setFirstName(user.getFirstName());
        storedUser.setLastName(user.getLastName());
        storedUser.setEmail(user.getEmail());
        storedUser.setPartition((Partition)this.getContext().getRealm());
        this.updateIdentityType((IdentityType)user, (IdentityType)storedUser);
        this.getAgentsForCurrentRealm().put(storedUser.getLoginName(), (Agent)storedUser);
        this.flushAgents();
        this.getContext().getEventBridge().raiseEvent((Object)new UserCreatedEvent((User)storedUser));
    }

    private void addAgent(Agent agent) {
        SimpleAgent storedAgent = new SimpleAgent(agent.getLoginName());
        storedAgent.setPartition((Partition)this.getContext().getRealm());
        this.updateIdentityType((IdentityType)agent, (IdentityType)storedAgent);
        this.getAgentsForCurrentRealm().put(storedAgent.getLoginName(), (Agent)storedAgent);
        this.flushAgents();
        this.getContext().getEventBridge().raiseEvent((Object)new AgentCreatedEvent((Agent)storedAgent));
    }

    private void addRelationship(Relationship relationship) {
        FileRelationshipStorage fileRelationship = new FileRelationshipStorage();
        fileRelationship.setId(relationship.getId());
        fileRelationship.setType(relationship.getClass().getName());
        this.updateRelationshipIdentity(relationship, fileRelationship);
        this.updateRelationshipAttributes(relationship, fileRelationship);
        Map<String, List<FileRelationshipStorage>> relationshipsMap = this.getRelationshipsForCurrentPartition();
        List<FileRelationshipStorage> relationships = relationshipsMap.get(relationship.getClass().getName());
        if (relationships == null) {
            relationships = new ArrayList<FileRelationshipStorage>();
            relationshipsMap.put(relationship.getClass().getName(), relationships);
        }
        relationships.add(fileRelationship);
        this.flushRelationships();
        this.getContext().getEventBridge().raiseEvent((Object)new RelationshipCreatedEvent(relationship));
    }

    private void updateRelationshipIdentity(Relationship relationship, FileRelationshipStorage fileRelationship) {
        List relationshipIdentityTypes = PropertyQueries.createQuery(relationship.getClass()).addCriteria(new AnnotatedPropertyCriteria(RelationshipIdentity.class)).getResultList();
        for (Property annotatedProperty : relationshipIdentityTypes) {
            IdentityType value = (IdentityType)annotatedProperty.getValue(relationship);
            if (Agent.class.isInstance(value)) {
                Agent agent = (Agent)value;
                this.lookupAgent(agent);
            }
            if (Role.class.isInstance(value)) {
                Role role = (Role)value;
                this.lookupRole(role);
            }
            if (Group.class.isInstance(value)) {
                Group group = (Group)value;
                this.lookupGroup(group);
            }
            fileRelationship.getIdentityTypes().put(annotatedProperty.getName(), value);
        }
    }

    private void updateRelationshipAttributes(Relationship relationship, FileRelationshipStorage fileRelationship) {
        fileRelationship.getAttributes().clear();
        Collection attributes = relationship.getAttributes();
        for (Attribute attribute : attributes) {
            fileRelationship.getAttributes().put(attribute.getName(), attribute.getValue());
        }
    }

    private void updateRole(Role updatedRole) {
        Role storedRole = this.lookupRole(updatedRole);
        if (storedRole != updatedRole) {
            this.updateIdentityType((IdentityType)updatedRole, (IdentityType)storedRole);
        }
        this.getRolesForCurrentPartition().put(storedRole.getName(), storedRole);
        this.flushRoles();
        this.getContext().getEventBridge().raiseEvent((Object)new RoleUpdatedEvent(updatedRole));
    }

    private void updateGroup(Group updatedGroup) {
        Group storedGroup = this.lookupGroup(updatedGroup);
        if (storedGroup != updatedGroup) {
            this.updateIdentityType((IdentityType)updatedGroup, (IdentityType)storedGroup);
        }
        this.getGroupsForCurrentPartition().put(storedGroup.getName(), storedGroup);
        this.flushGroups();
        this.getContext().getEventBridge().raiseEvent((Object)new GroupUpdatedEvent(updatedGroup));
    }

    private void updateUser(User updatedUser) {
        User storedUser = this.lookupUser(updatedUser);
        if (storedUser != updatedUser) {
            storedUser.setFirstName(updatedUser.getFirstName());
            storedUser.setLastName(updatedUser.getLastName());
            storedUser.setEmail(updatedUser.getEmail());
            this.updateIdentityType((IdentityType)updatedUser, (IdentityType)storedUser);
        }
        this.getAgentsForCurrentRealm().put(storedUser.getLoginName(), (Agent)storedUser);
        this.flushAgents();
        this.getContext().getEventBridge().raiseEvent((Object)new UserUpdatedEvent(updatedUser));
    }

    private void updateAgent(Agent updatedAgent) {
        Agent storedAgent = this.lookupAgent(updatedAgent);
        if (storedAgent != updatedAgent) {
            this.updateIdentityType((IdentityType)updatedAgent, (IdentityType)storedAgent);
        }
        this.getAgentsForCurrentRealm().put(storedAgent.getLoginName(), storedAgent);
        this.flushAgents();
        this.getContext().getEventBridge().raiseEvent((Object)new AgentUpdatedEvent(updatedAgent));
    }

    private void updateRelationship(Relationship relationship) {
        List<FileRelationshipStorage> relationships = this.getRelationshipsForCurrentPartition().get(relationship.getClass().getName());
        for (FileRelationshipStorage storedRelationship : new ArrayList<FileRelationshipStorage>(relationships)) {
            if (!storedRelationship.getId().equals(relationship.getId())) continue;
            this.updateAttributedType((AttributedType)relationship, (AttributedType)this.convertToRelationship(storedRelationship));
            this.updateRelationshipAttributes(relationship, storedRelationship);
        }
        this.flushRelationships();
        this.getContext().getEventBridge().raiseEvent((Object)new RelationshipUpdatedEvent(relationship));
    }

    private void updateIdentityType(IdentityType fromIdentityType, IdentityType toIdentityType) {
        toIdentityType.setEnabled(fromIdentityType.isEnabled());
        toIdentityType.setCreatedDate(fromIdentityType.getCreatedDate());
        toIdentityType.setExpirationDate(fromIdentityType.getExpirationDate());
        this.updateAttributedType((AttributedType)fromIdentityType, (AttributedType)toIdentityType);
        fromIdentityType.setId(toIdentityType.getId());
        fromIdentityType.setPartition(toIdentityType.getPartition());
    }

    private void updateAttributedType(AttributedType fromIdentityType, AttributedType toIdentityType) {
        toIdentityType.setId(fromIdentityType.getId());
        for (Object object : toIdentityType.getAttributes().toArray()) {
            Attribute attribute = (Attribute)object;
            toIdentityType.removeAttribute(attribute.getName());
        }
        for (Attribute attrib : fromIdentityType.getAttributes()) {
            toIdentityType.setAttribute(attrib);
        }
    }

    private Role lookupRole(String roleName, Partition partition) {
        Tier tier;
        Role role = this.getRolesForPartition(partition).get(roleName);
        if (role == null && Tier.class.isInstance(partition) && (tier = (Tier)partition).getParent() != null) {
            role = this.lookupRole(roleName, (Partition)tier.getParent());
        }
        return role;
    }

    private Group lookupGroup(String groupName, Partition partition) {
        Tier tier;
        Group group = this.getGroupsForPartition(partition).get(groupName);
        if (group == null && Tier.class.isInstance(partition) && (tier = (Tier)partition).getParent() != null) {
            group = this.lookupGroup(groupName, (Partition)tier.getParent());
        }
        return group;
    }

    private void removeRelationship(Relationship relationship) {
        List<FileRelationshipStorage> relationships = this.getRelationshipsForCurrentPartition().get(relationship.getClass().getName());
        for (FileRelationshipStorage storedRelationship : new ArrayList<FileRelationshipStorage>(relationships)) {
            if (!storedRelationship.getId().equals(relationship.getId())) continue;
            relationships.remove(storedRelationship);
        }
        this.flushRelationships();
        this.getContext().getEventBridge().raiseEvent((Object)new RelationshipDeletedEvent(relationship));
    }

    private void removeRole(Role role) {
        Role storedRole = this.lookupRole(role);
        this.getRolesForCurrentPartition().remove(storedRole.getName());
        this.removeRelationships((IdentityType)storedRole);
        this.flushRoles();
        this.getContext().getEventBridge().raiseEvent((Object)new RoleDeletedEvent(role));
    }

    private void removeGroup(Group group) {
        Group storedGroup = this.lookupGroup(group);
        this.getGroupsForCurrentPartition().remove(storedGroup.getName());
        this.removeRelationships((IdentityType)storedGroup);
        this.flushGroups();
        this.getContext().getEventBridge().raiseEvent((Object)new GroupDeletedEvent(group));
    }

    private void removeAgent(Agent agent) {
        Agent storedAgent = this.lookupAgent(agent);
        this.getAgentsForCurrentRealm().remove(storedAgent.getLoginName());
        this.removeRelationships((IdentityType)storedAgent);
        this.credentialStore.removeCredentials(storedAgent);
        this.flushAgents();
        if (IDMUtil.isUserType(agent.getClass())) {
            this.getContext().getEventBridge().raiseEvent((Object)new UserDeletedEvent((User)agent));
        }
        this.getContext().getEventBridge().raiseEvent((Object)new AgentDeletedEvent(agent));
    }

    private void removeRelationships(IdentityType identityTypeToRemove) {
        Set<Map.Entry<String, List<FileRelationshipStorage>>> entrySet = this.getRelationshipsForCurrentPartition().entrySet();
        for (Map.Entry<String, List<FileRelationshipStorage>> entry : entrySet) {
            List<FileRelationshipStorage> relationships = entry.getValue();
            for (FileRelationshipStorage fileRelationshipStorage : new ArrayList<FileRelationshipStorage>(relationships)) {
                Collection<IdentityType> identityTypes = fileRelationshipStorage.getIdentityTypes().values();
                for (IdentityType relationshipIdentityType : identityTypes) {
                    if (!identityTypeToRemove.getClass().isInstance(relationshipIdentityType) || !identityTypeToRemove.getId().equals(relationshipIdentityType.getId())) continue;
                    this.remove((AttributedType)this.convertToRelationship(fileRelationshipStorage));
                }
            }
        }
        this.flushRelationships();
    }

    private Map<String, Group> getGroupsForPartition(Partition partition) {
        return this.getConfig().getGroups(partition.getId());
    }

    private Map<String, Role> getRolesForPartition(Partition partition) {
        return this.getConfig().getRoles(partition.getId());
    }

    private Map<String, Agent> getAgentsForPartition(Partition partition) {
        return this.getConfig().getAgents(partition.getId());
    }

    protected Map<String, List<FileRelationshipStorage>> getRelationshipsForCurrentPartition() {
        return this.getConfig().getRelationships(this.getContext());
    }

    private Map<String, Role> getRolesForCurrentPartition() {
        return this.getConfig().getRoles(this.getCurrentPartition().getId());
    }

    private Map<String, Group> getGroupsForCurrentPartition() {
        return this.getConfig().getGroups(this.getCurrentPartition().getId());
    }

    private Map<String, Agent> getAgentsForCurrentRealm() {
        return this.getConfig().getAgents(this.getContext());
    }

    private void flushRoles() {
        this.getConfig().flushRoles(this.getContext());
    }

    private void flushGroups() {
        this.getConfig().flushGroups(this.getContext());
    }

    private void flushAgents() {
        this.getConfig().flushAgents(this.getContext());
    }

    private void flushRelationships() {
        this.getConfig().flushRelationships(this.getContext());
    }

    private IdentityManagementException createNotImplementedYetException() {
        return new IdentityManagementException("Not implemented yet.");
    }

    private IdentityManagementException createUnsupportedIdentityTypeException(Class<? extends IdentityType> identityTypeClass) {
        return new IdentityManagementException("Unsupported IdentityType [" + identityTypeClass.getName() + "].");
    }

    private IdentityManagementException createUnsupportedAttributedType(Class<? extends AttributedType> type) {
        return new IdentityManagementException("Unsupported AttributedType [" + type.getName() + "].");
    }

    private void checkNotNulId(AttributedType attributedType) throws IdentityManagementException {
        if (attributedType.getId() == null) {
            throw new IdentityManagementException("No identifier provided.");
        }
    }
}

