/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.CredentialUtils;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.Stored;
import org.picketlink.idm.file.internal.FileBasedIdentityStore;
import org.picketlink.idm.file.internal.FileCredentialStorage;
import org.picketlink.idm.file.internal.FileIdentityStoreConfiguration;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.internal.util.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.NamedPropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.PropertyQueries;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

public class FileCredentialStore
implements CredentialStore {
    private FileBasedIdentityStore identityStore;

    public FileCredentialStore(FileBasedIdentityStore identityStore) {
        this.identityStore = identityStore;
    }

    public void validateCredentials(Credentials credentials) {
        CredentialHandler handler = this.getContext().getCredentialValidator(credentials.getClass(), (IdentityStore)this.identityStore);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for validating Credentials of type [" + credentials.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.validate(credentials, (IdentityStore)this.identityStore);
    }

    public void updateCredential(Agent agent, Object credential, Date effectiveDate, Date expiryDate) {
        CredentialHandler handler = this.getContext().getCredentialUpdater(credential.getClass(), (IdentityStore)this.identityStore);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for updating Credentials of type [" + credential.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.update(agent, credential, (IdentityStore)this.identityStore, effectiveDate, expiryDate);
    }

    public void storeCredential(Agent agent, CredentialStorage storage) {
        List<FileCredentialStorage> credentials = this.getCredentials(agent, storage.getClass());
        FileCredentialStorage credential = new FileCredentialStorage();
        List annotatedTypes = PropertyQueries.createQuery(storage.getClass()).addCriteria(new AnnotatedPropertyCriteria(Stored.class)).getResultList();
        for (Property property : annotatedTypes) {
            credential.getStoredFields().put(property.getName(), (Serializable)property.getValue(storage));
        }
        if (credential.getEffectiveDate() == null) {
            credential.setEffectiveDate(new Date());
        }
        credentials.add(credential);
        this.flushCredentials();
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(Agent agent, Class<T> storageClass) {
        return CredentialUtils.getCurrentCredential(agent, this, storageClass);
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(Agent agent, Class<T> storageTyper) {
        ArrayList<T> storedCredentials = new ArrayList<T>();
        List<FileCredentialStorage> credentials = this.getCredentials(agent, storageTyper);
        for (FileCredentialStorage fileCredentialStorage : credentials) {
            storedCredentials.add(this.convertToCredentialStorage(storageTyper, fileCredentialStorage));
        }
        return storedCredentials;
    }

    public void removeCredentials(Agent agent) {
        this.getCredentialsForCurrentPartition().remove(agent.getLoginName());
        this.flushCredentials();
    }

    private <T extends CredentialStorage> T convertToCredentialStorage(Class<T> storageClass, FileCredentialStorage fileCredentialStorage) {
        CredentialStorage storage = null;
        try {
            storage = (CredentialStorage)storageClass.newInstance();
        }
        catch (Exception e) {
            throw new IdentityManagementException("Could not create CredentialStorage instance for class [" + storageClass.getName() + "].", (Throwable)e);
        }
        Set<Map.Entry<String, Serializable>> storedFields = fileCredentialStorage.getStoredFields().entrySet();
        for (Map.Entry<String, Serializable> storedField : storedFields) {
            List annotatedTypes = PropertyQueries.createQuery(storageClass).addCriteria(new NamedPropertyCriteria(storedField.getKey())).getResultList();
            if (annotatedTypes.isEmpty()) {
                throw new IdentityManagementException("Could not find property [" + storedField.getKey() + "] on CredentialStorage [" + storageClass.getName() + "].");
            }
            if (annotatedTypes.size() > 1) {
                throw new IdentityManagementException("Ambiguos property [" + storedField.getKey() + "] on CredentialStorage [" + storageClass.getName() + "].");
            }
            annotatedTypes.get(0).setValue(storage, storedField.getValue());
        }
        return (T)storage;
    }

    private List<FileCredentialStorage> getCredentials(Agent agent, Class<? extends CredentialStorage> storageType) {
        List<FileCredentialStorage> credentials;
        Map<String, List<FileCredentialStorage>> agentCredentials = this.getCredentialsForCurrentPartition().get(agent.getLoginName());
        if (agentCredentials == null) {
            agentCredentials = new HashMap<String, List<FileCredentialStorage>>();
        }
        if ((credentials = agentCredentials.get(storageType.getName())) == null) {
            credentials = new ArrayList<FileCredentialStorage>();
        }
        agentCredentials.put(storageType.getName(), credentials);
        this.getCredentialsForCurrentPartition().put(agent.getLoginName(), agentCredentials);
        return credentials;
    }

    private IdentityStoreInvocationContext getContext() {
        return this.identityStore.getContext();
    }

    private FileIdentityStoreConfiguration getConfig() {
        return this.identityStore.getConfig();
    }

    private Map<String, Map<String, List<FileCredentialStorage>>> getCredentialsForCurrentPartition() {
        return this.getConfig().getCredentials(this.getContext());
    }

    private void flushCredentials() {
        this.getConfig().flushCredentials(this.getContext());
    }
}

